/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.SerialProxy;
import io.jenetics.ext.moea.Vec;
import io.jenetics.ext.moea.Vecs;
import io.jenetics.internal.util.SerialIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

final class SimpleLongVec
implements Vec<long[]>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final long[] _data;

    SimpleLongVec(long[] data) {
        Vecs.checkVecLength(data.length);
        this._data = data;
    }

    @Override
    public long[] data() {
        return this._data;
    }

    @Override
    public int length() {
        return this._data.length;
    }

    @Override
    public ElementComparator<long[]> comparator() {
        return SimpleLongVec::cmp;
    }

    private static int cmp(long[] u, long[] v, int i) {
        return Long.compare(u[i], v[i]);
    }

    @Override
    public ElementDistance<long[]> distance() {
        return SimpleLongVec::dist;
    }

    private static double dist(long[] u, long[] v, int i) {
        return u[i] - v[i];
    }

    @Override
    public Comparator<long[]> dominance() {
        return Pareto::dominance;
    }

    public int hashCode() {
        return Arrays.hashCode(this._data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof SimpleLongVec)) return false;
        SimpleLongVec other = (SimpleLongVec)obj;
        if (!Arrays.equals(other._data, this._data)) return false;
        return true;
    }

    public String toString() {
        return Arrays.toString(this._data);
    }

    private Object writeReplace() {
        return new SerialProxy(2, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        SerialIO.writeLongArray((long[])this._data, (DataOutput)out);
    }

    static SimpleLongVec read(DataInput in) throws IOException {
        return new SimpleLongVec(SerialIO.readLongArray((DataInput)in));
    }
}

