/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.rewriting.SerialProxy;
import io.jenetics.ext.rewriting.TreeRewriteRule;
import io.jenetics.ext.rewriting.TreeRewriter;
import io.jenetics.ext.util.TreeNode;
import io.jenetics.internal.util.SerialIO;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TRS<V>
implements TreeRewriter<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ISeq<TreeRewriteRule<V>> _rules;

    public TRS(ISeq<TreeRewriteRule<V>> rules) {
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("Rewrite rules must not be empty.");
        }
        this._rules = rules;
    }

    @Override
    public int rewrite(TreeNode<V> tree, int limit) {
        return TreeRewriter.rewrite(tree, limit, this._rules);
    }

    public <B> TRS<B> map(Function<? super V, ? extends B> mapper) {
        return new TRS<V>(this._rules.map(rule -> rule.map(mapper)));
    }

    public int hashCode() {
        return this._rules.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TRS)) return false;
        TRS other = (TRS)obj;
        if (!this._rules.equals(other._rules)) return false;
        return true;
    }

    public String toString() {
        return this._rules.stream().map(Objects::toString).collect(Collectors.joining("; "));
    }

    public static <V> TRS<V> parse(Function<? super String, ? extends V> mapper, String ... rules) {
        return new TRS<V>(ISeq.of((Object[])rules).map(rule -> TreeRewriteRule.parse(rule, mapper)));
    }

    public static TRS<String> parse(String ... rules) {
        return TRS.parse(Function.identity(), rules);
    }

    private Object writeReplace() {
        return new SerialProxy(5, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        SerialIO.writeInt((int)this._rules.length(), (DataOutput)out);
        for (int i = 0; i < this._rules.length(); ++i) {
            out.writeObject(this._rules.get(i));
        }
    }

    static Object read(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = SerialIO.readInt((DataInput)in);
        MSeq rules = MSeq.ofLength((int)length);
        for (int i = 0; i < length; ++i) {
            rules.set(i, in.readObject());
        }
        return new TRS(rules.toISeq());
    }
}

