/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.rewriting.TreeMatchResult;
import io.jenetics.ext.rewriting.TreePattern;
import io.jenetics.ext.util.Tree;
import java.util.Objects;
import java.util.stream.Stream;

public final class TreeMatcher<V> {
    private final TreePattern<V> _pattern;
    private final Tree<V, ?> _tree;

    private TreeMatcher(TreePattern<V> pattern, Tree<V, ?> tree) {
        this._pattern = Objects.requireNonNull(pattern);
        this._tree = Objects.requireNonNull(tree);
    }

    public TreePattern<V> pattern() {
        return this._pattern;
    }

    public Tree<V, ?> tree() {
        return this._tree;
    }

    public boolean matches() {
        return this._pattern.matches(this._tree);
    }

    public Stream<TreeMatchResult<V>> results() {
        return this._tree.stream().flatMap(tree -> this._pattern.match((Tree<V, ?>)tree).stream());
    }

    static <V> TreeMatcher<V> of(TreePattern<V> pattern, Tree<V, ?> tree) {
        return new TreeMatcher<V>(pattern, tree);
    }
}

