/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntFunction;

final class IntFunctionIterator<T>
implements Iterator<T> {
    private final IntFunction<? extends T> _mapper;
    private final int _length;
    private int _cursor = 0;

    IntFunctionIterator(IntFunction<? extends T> mapper, int length) {
        this._mapper = Objects.requireNonNull(mapper);
        this._length = length;
    }

    @Override
    public boolean hasNext() {
        return this._cursor != this._length;
    }

    @Override
    public T next() {
        int i = this._cursor;
        if (this._cursor >= this._length) {
            throw new NoSuchElementException();
        }
        this._cursor = i + 1;
        return this._mapper.apply(i);
    }
}

