/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.internal.util.Escaper;
import io.jenetics.ext.util.Tree;
import java.util.Objects;
import java.util.function.Function;

final class ParenthesesTrees {
    private static final char[] PROTECTED_CHARS = new char[]{'(', ')', ','};
    static final char ESCAPE_CHAR = '\\';
    private static final Escaper ESCAPER = new Escaper('\\', PROTECTED_CHARS);

    private ParenthesesTrees() {
    }

    static String escape(CharSequence value) {
        return ESCAPER.escape(value);
    }

    static String unescape(CharSequence value) {
        return ESCAPER.unescape(value);
    }

    static <V> String toString(Tree<V, ?> tree, Function<? super V, ? extends CharSequence> mapper) {
        Objects.requireNonNull(mapper);
        if (tree != null) {
            StringBuilder out = new StringBuilder();
            ParenthesesTrees.toString(out, tree, mapper);
            return out.toString();
        }
        return "null";
    }

    private static <V> void toString(StringBuilder out, Tree<V, ?> tree, Function<? super V, ? extends CharSequence> mapper) {
        out.append(ParenthesesTrees.escape(mapper.apply(tree.value())));
        if (!tree.isLeaf()) {
            out.append("(");
            ParenthesesTrees.toString(out, tree.childAt(0), mapper);
            for (int i = 1; i < tree.childCount(); ++i) {
                out.append(",");
                ParenthesesTrees.toString(out, tree.childAt(i), mapper);
            }
            out.append(")");
        }
    }
}

