/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

final class TreeChildIterator<V, T extends Tree<V, T>>
implements ListIterator<T> {
    private final T _tree;
    private int cursor = 0;

    TreeChildIterator(T tree) {
        this._tree = (Tree)Objects.requireNonNull(tree, "Tree must not be null.");
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this._tree.childCount();
    }

    @Override
    public T next() {
        int i = this.cursor;
        if (this.cursor >= this._tree.childCount()) {
            throw new NoSuchElementException();
        }
        this.cursor = i + 1;
        return this._tree.childAt(i);
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != 0;
    }

    @Override
    public T previous() {
        int i = this.cursor - 1;
        if (i < 0) {
            throw new NoSuchElementException();
        }
        this.cursor = i;
        return this._tree.childAt(i);
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void set(T value) {
        throw new UnsupportedOperationException("Iterator is immutable.");
    }

    @Override
    public void add(T value) {
        throw new UnsupportedOperationException("Can't change Iterator size.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't change Iterator size.");
    }
}

