/*
 * Java Genetic Algorithm Library (jenetics-7.1.1).
 * Copyright (c) 2007-2022 Franz Wilhelmstötter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author:
 *    Franz Wilhelmstötter (franz.wilhelmstoetter@gmail.com)
 */
package io.jenetics.ext.moea;

import static java.util.Objects.requireNonNull;

import java.util.Comparator;

/**
 * @author <a href="mailto:franz.wilhelmstoetter@gmail.com">Franz Wilhelmstötter</a>
 * @version 5.2
 * @since 5.2
 */
abstract class GeneralVec<T> implements Vec<T> {

	final T _data;
	final ElementComparator<T> _comparator;
	final ElementDistance<T> _distance;
	final Comparator<T> _dominance;

	GeneralVec(
		final T data,
		final ElementComparator<T> comparator,
		final ElementDistance<T> distance,
		final Comparator<T> dominance
	) {
		_data = requireNonNull(data);
		_comparator = requireNonNull(comparator);
		_distance = requireNonNull(distance);
		_dominance = requireNonNull(dominance);
	}

	@Override
	public T data() {
		return _data;
	}

	@Override
	public ElementComparator<T> comparator() {
		return _comparator;
	}

	@Override
	public ElementDistance<T> distance() {
		return _distance;
	}

	@Override
	public Comparator<T> dominance() {
		return _dominance;
	}

}
