/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.ext.grammar.BnfTokenizer;
import io.jenetics.ext.grammar.Cfg;
import io.jenetics.ext.internal.parser.ParsingException;
import io.jenetics.ext.internal.parser.Token;
import io.jenetics.ext.internal.parser.TokenParser;
import java.util.ArrayList;
import java.util.List;

final class BnfParser
extends TokenParser<String> {
    Cfg.NonTerminal<String> start = null;
    final List<Cfg.Rule<String>> rules = new ArrayList<Cfg.Rule<String>>();
    final List<Cfg.Symbol<String>> symbols = new ArrayList<Cfg.Symbol<String>>();
    final List<Cfg.Expression<String>> alternatives = new ArrayList<Cfg.Expression<String>>();

    BnfParser(BnfTokenizer tokenizer) {
        super(tokenizer, 4);
    }

    public Cfg<String> parse() {
        this.rulelist();
        return Cfg.of(this.rules);
    }

    private void rulelist() {
        do {
            this.rule();
        } while (this.LA(1) != Token.Type.EOF.code());
    }

    private void rule() {
        this.start = this.lhs();
        this.match(BnfTokenizer.BnfTokenType.ASSIGN);
        this.rhs();
        this.rules.add(new Cfg.Rule<String>(this.start, this.alternatives));
        this.start = null;
        this.alternatives.clear();
    }

    private Cfg.NonTerminal<String> lhs() {
        return this.id();
    }

    private void rhs() {
        this.alternatives();
    }

    private void alternatives() {
        this.alternative();
        if (!this.symbols.isEmpty()) {
            this.alternatives.add(new Cfg.Expression(this.symbols));
            this.symbols.clear();
        }
        while (this.LA(1) == BnfTokenizer.BnfTokenType.BAR.code()) {
            this.match(BnfTokenizer.BnfTokenType.BAR);
            this.alternative();
            if (this.symbols.isEmpty()) continue;
            this.alternatives.add(new Cfg.Expression(this.symbols));
            this.symbols.clear();
        }
    }

    private void alternative() {
        do {
            this.element();
        } while (this.LA(4) != BnfTokenizer.BnfTokenType.ASSIGN.code() && (this.LA(1) == BnfTokenizer.BnfTokenType.STRING.code() || this.LA(1) == BnfTokenizer.BnfTokenType.QUOTED_STRING.code() || this.LA(1) == BnfTokenizer.BnfTokenType.ID.code() || this.LA(1) == BnfTokenizer.BnfTokenType.LT.code()));
    }

    private void element() {
        if (this.LA(1) == BnfTokenizer.BnfTokenType.STRING.code()) {
            this.symbols.add(this.text());
        } else if (this.LA(1) == BnfTokenizer.BnfTokenType.QUOTED_STRING.code()) {
            this.symbols.add(this.text());
        } else if (this.LA(1) == BnfTokenizer.BnfTokenType.ID.code()) {
            this.symbols.add(this.text());
        } else if (this.LA(1) == BnfTokenizer.BnfTokenType.LT.code()) {
            this.symbols.add(this.id());
        } else {
            throw new ParsingException(String.format("Expecting %s but found %s.", List.of(BnfTokenizer.BnfTokenType.STRING, BnfTokenizer.BnfTokenType.QUOTED_STRING, BnfTokenizer.BnfTokenType.ID, BnfTokenizer.BnfTokenType.LT), this.LT(1)));
        }
    }

    private Cfg.Terminal<String> text() {
        if (this.LA(1) == BnfTokenizer.BnfTokenType.STRING.code()) {
            return BnfParser.terminal((String)this.match(BnfTokenizer.BnfTokenType.STRING).value());
        }
        if (this.LA(1) == BnfTokenizer.BnfTokenType.QUOTED_STRING.code()) {
            return BnfParser.terminal((String)this.match(BnfTokenizer.BnfTokenType.QUOTED_STRING).value());
        }
        if (this.LA(1) == BnfTokenizer.BnfTokenType.ID.code()) {
            return BnfParser.terminal((String)this.match(BnfTokenizer.BnfTokenType.ID).value());
        }
        throw new ParsingException(String.format("Expecting %s but found %s.", List.of(BnfTokenizer.BnfTokenType.STRING, BnfTokenizer.BnfTokenType.QUOTED_STRING, BnfTokenizer.BnfTokenType.ID), this.LT(1)));
    }

    private static Cfg.Terminal<String> terminal(String value) {
        if (value.isEmpty()) {
            throw new ParsingException("Terminal value must not be empty.");
        }
        return new Cfg.Terminal<String>(value, value);
    }

    private Cfg.NonTerminal<String> id() {
        this.match(BnfTokenizer.BnfTokenType.LT);
        Cfg.NonTerminal<String> result = this.ruleid();
        this.match(BnfTokenizer.BnfTokenType.GT);
        return result;
    }

    private Cfg.NonTerminal<String> ruleid() {
        String name = (String)this.match(BnfTokenizer.BnfTokenType.ID).value();
        if (name.isEmpty()) {
            throw new ParsingException("Rule id must not be empty.");
        }
        return new Cfg.NonTerminal<String>(name);
    }
}

