/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.grammar;

import io.jenetics.ext.grammar.Cfg;
import io.jenetics.ext.grammar.Generator;
import io.jenetics.ext.grammar.SymbolIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SentenceGenerator<T>
implements Generator<T, List<Cfg.Terminal<T>>> {
    private final SymbolIndex _index;
    private final Expansion _expansion;
    private final int _limit;

    public SentenceGenerator(SymbolIndex index, Expansion expansion, int limit) {
        this._index = Objects.requireNonNull(index);
        this._expansion = Objects.requireNonNull(expansion);
        this._limit = limit;
    }

    public SentenceGenerator(SymbolIndex index, int limit) {
        this(index, Expansion.LEFT_MOST, limit);
    }

    @Override
    public List<Cfg.Terminal<T>> generate(Cfg<? extends T> cfg) {
        ArrayList<Cfg.Symbol<T>> sentence = new ArrayList<Cfg.Symbol<T>>();
        this.generate(Cfg.upcast(cfg), sentence);
        List result = sentence;
        return List.copyOf(result);
    }

    void generate(Cfg<T> cfg, List<Cfg.Symbol<T>> symbols) {
        boolean proceed;
        symbols.add(cfg.start());
        do {
            proceed = false;
            ListIterator<Cfg.Symbol<T>> sit = symbols.listIterator();
            while (sit.hasNext() && (this._expansion == Expansion.LEFT_TO_RIGHT || !proceed)) {
                Cfg.Symbol<T> symbol = sit.next();
                if (!(symbol instanceof Cfg.NonTerminal)) continue;
                Cfg.NonTerminal nt = (Cfg.NonTerminal)symbol;
                sit.remove();
                Generator.select(nt, cfg, this._index).forEach(sit::add);
                proceed = true;
            }
            if (symbols.size() <= this._limit) continue;
            symbols.clear();
            proceed = false;
        } while (proceed);
    }

    public static String toString(List<? extends Cfg.Symbol<?>> sentence) {
        return sentence.stream().map(Cfg.Symbol::name).collect(Collectors.joining());
    }

    public static enum Expansion {
        LEFT_MOST,
        LEFT_TO_RIGHT;

    }
}

