/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ConcatSpliterator<T>
implements Spliterator<T> {
    private final Deque<Spliterator<T>> _spliterators;
    private final int _characteristics;
    private final long _size;

    public ConcatSpliterator(Collection<Spliterator<T>> spliterators) {
        this._spliterators = new ArrayDeque<Spliterator<T>>(spliterators);
        int characteristics = 16464;
        long size = 0L;
        for (Spliterator<T> spliterator : spliterators) {
            characteristics &= spliterator.characteristics();
            size += spliterator.estimateSize();
        }
        if (size < 0L) {
            size = Long.MAX_VALUE;
            characteristics &= 0xFFFFBFBF;
        }
        this._characteristics = characteristics;
        this._size = size;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean advance = true;
        if (!this._spliterators.isEmpty()) {
            Spliterator<? super T> spliterator = this._spliterators.peek();
            assert (spliterator != null);
            if (!spliterator.tryAdvance(action)) {
                this._spliterators.removeFirst();
                advance = !this._spliterators.isEmpty();
            }
        } else {
            advance = false;
        }
        return advance;
    }

    @Override
    public Spliterator<T> trySplit() {
        List<Spliterator<T>> split = this._spliterators.stream().map(Spliterator::trySplit).toList();
        return split.stream().noneMatch(Objects::isNull) ? new ConcatSpliterator<T>(split) : null;
    }

    @Override
    public long estimateSize() {
        return this._size;
    }

    @Override
    public int characteristics() {
        return this._characteristics;
    }
}

