/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

public final class Escaper {
    private final char[] _protect;
    private final char _escape;

    public Escaper(char escape, char ... protect) {
        this._protect = (char[])protect.clone();
        this._escape = escape;
    }

    public String escape(CharSequence value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (this.isProtectedChar(c)) {
                result.append(this._escape);
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean isProtectedChar(char c) {
        for (char c1 : this._protect) {
            if (c != c1) continue;
            return true;
        }
        return false;
    }

    public String unescape(CharSequence value) {
        StringBuilder result = new StringBuilder();
        boolean escaping = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == this._escape && !escaping && i + 1 < value.length() && this.isProtectedChar(value.charAt(i + 1))) {
                escaping = true;
                continue;
            }
            if (escaping) {
                escaping = false;
            }
            result.append(c);
        }
        return result.toString();
    }
}

