/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Optimize;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.internal.util.IntComparator;
import io.jenetics.util.BaseSeq;
import java.util.Comparator;
import java.util.function.ToIntFunction;

final class CrowdedComparator<T>
implements IntComparator {
    private final int[] _rank;
    private final double[] _dist;

    CrowdedComparator(BaseSeq<? extends T> population, Optimize opt, Comparator<? super T> dominance, ElementComparator<? super T> comparator, ElementDistance<? super T> distance, ToIntFunction<? super T> dimension) {
        this._rank = Pareto.rank(population, opt == Optimize.MAXIMUM ? dominance : dominance.reversed());
        this._dist = Pareto.crowdingDistance(population, opt == Optimize.MAXIMUM ? comparator : comparator.reversed(), distance, dimension);
    }

    public int compare(int i, int j) {
        if (this.cco(i, j)) {
            return 1;
        }
        if (this.cco(j, i)) {
            return -1;
        }
        return 0;
    }

    private boolean cco(int i, int j) {
        return this._rank[i] < this._rank[j] || this._rank[i] == this._rank[j] && this._dist[i] > this._dist[j];
    }
}

