/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.SimpleDoubleVec;
import io.jenetics.ext.moea.SimpleIntVec;
import io.jenetics.ext.moea.SimpleLongVec;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;

final class SerialProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    static final byte SIMPLE_INT_VEC = 1;
    static final byte SIMPLE_LONG_VEC = 2;
    static final byte SIMPLE_DOUBLE_VEC = 3;
    private byte _type;
    private Object _object;

    public SerialProxy() {
    }

    SerialProxy(byte type, Object object) {
        this._type = type;
        this._object = object;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this._type);
        switch (this._type) {
            case 1: {
                ((SimpleIntVec)this._object).write(out);
                break;
            }
            case 2: {
                ((SimpleLongVec)this._object).write(out);
                break;
            }
            case 3: {
                ((SimpleDoubleVec)this._object).write(out);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this._type = in.readByte();
        this._object = switch (this._type) {
            case 1 -> SimpleIntVec.read(in);
            case 2 -> SimpleLongVec.read(in);
            case 3 -> SimpleDoubleVec.read(in);
            default -> throw new StreamCorruptedException("Unknown serialized type.");
        };
    }

    private Object readResolve() {
        return this._object;
    }
}

