/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Pareto;
import io.jenetics.ext.moea.SimpleDoubleVec;
import io.jenetics.ext.moea.SimpleIntVec;
import io.jenetics.ext.moea.SimpleLongVec;
import io.jenetics.ext.moea.SimpleObjectVec;
import io.jenetics.internal.math.Basics;
import java.util.Comparator;

public interface Vec<T>
extends Comparable<Vec<T>> {
    public T data();

    public int length();

    public ElementComparator<T> comparator();

    public ElementDistance<T> distance();

    public Comparator<T> dominance();

    default public int compare(Vec<T> other, int index) {
        return this.comparator().compare(this.data(), other.data(), index);
    }

    default public double distance(Vec<T> other, int index) {
        return this.distance().distance(this.data(), other.data(), index);
    }

    default public int dominance(Vec<T> other) {
        return this.dominance().compare(this.data(), other.data());
    }

    @Override
    default public int compareTo(Vec<T> other) {
        return this.dominance(other);
    }

    public static <C extends Comparable<? super C>> int dominance(C[] u, C[] v) {
        return Vec.dominance(u, v, Comparator.naturalOrder());
    }

    public static <T> int dominance(T[] u, T[] v, Comparator<? super T> comparator) {
        return Pareto.dominance(u, v, comparator);
    }

    public static int dominance(int[] u, int[] v) {
        return Pareto.dominance(u, v);
    }

    public static int dominance(long[] u, long[] v) {
        return Pareto.dominance(u, v);
    }

    public static int dominance(double[] u, double[] v) {
        return Pareto.dominance(u, v);
    }

    public static <C extends Comparable<? super C>> Vec<C[]> of(C[] array) {
        return Vec.of(array, (V u, V v, int i) -> Basics.clamp((double)u[i].compareTo(v[i]), (double)-1.0, (double)1.0));
    }

    public static <C extends Comparable<? super C>> Vec<C[]> of(C[] array, ElementDistance<C[]> distance) {
        return Vec.of(array, Comparator.naturalOrder(), distance);
    }

    public static <T> Vec<T[]> of(T[] array, Comparator<? super T> comparator, ElementDistance<T[]> distance) {
        return new SimpleObjectVec<T>(array, comparator, distance);
    }

    public static Vec<int[]> of(int ... array) {
        return new SimpleIntVec(array);
    }

    public static Vec<long[]> of(long ... array) {
        return new SimpleLongVec(array);
    }

    public static Vec<double[]> of(double ... array) {
        return new SimpleDoubleVec(array);
    }
}

