/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.internal.util.Escaper;
import io.jenetics.ext.internal.util.Names;
import io.jenetics.ext.rewriting.SerialProxy;
import io.jenetics.ext.rewriting.TreeMatchResult;
import io.jenetics.ext.rewriting.TreeMatcher;
import io.jenetics.ext.util.Tree;
import io.jenetics.ext.util.TreeNode;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TreePattern<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeNode<Decl<V>> _pattern;
    private final SortedSet<Var<V>> _vars;
    private static final char VAR_PREFIX = '$';
    private static final char ESC_CHAR = '\\';
    private static final Escaper ESCAPER = new Escaper('\\', '$');

    public TreePattern(Tree<Decl<V>, ?> pattern) {
        this._pattern = TreeNode.ofTree(pattern);
        this._vars = TreePattern.extractVars(this._pattern);
    }

    private static <V> SortedSet<Var<V>> extractVars(TreeNode<Decl<V>> pattern) {
        TreeSet<Var> variables = new TreeSet<Var>();
        for (Tree tree : pattern) {
            Object v = tree.value();
            if (!(v instanceof Var)) continue;
            Var var = (Var)v;
            if (!tree.isLeaf()) {
                throw new IllegalArgumentException(String.format("Variable node '%s' is not a leaf: %s", tree.value(), tree.toParenthesesString()));
            }
            variables.add(var);
        }
        return Collections.unmodifiableSortedSet(variables);
    }

    TreeNode<Decl<V>> pattern() {
        return this._pattern;
    }

    public SortedSet<Var<V>> vars() {
        return this._vars;
    }

    public <B> TreePattern<B> map(Function<? super V, ? extends B> mapper) {
        return new TreePattern<V>(this._pattern.map((? super T d) -> d.map(mapper)));
    }

    public TreeMatcher<V> matcher(Tree<V, ?> tree) {
        return TreeMatcher.of(this, tree);
    }

    public Optional<TreeMatchResult<V>> match(Tree<V, ?> tree) {
        HashMap vars = new HashMap();
        boolean matches = TreePattern.matches(tree, this._pattern, vars);
        return matches ? Optional.of(TreeMatchResult.of(tree, vars)) : Optional.empty();
    }

    public boolean matches(Tree<V, ?> tree) {
        return TreePattern.matches(tree, this._pattern, new HashMap());
    }

    private static <V> boolean matches(Tree<V, ?> node, Tree<Decl<V>, ?> pattern, Map<Var<V>, Tree<V, ?>> vars) {
        Decl<V> decl = pattern.value();
        if (decl instanceof Var) {
            Var var = (Var)decl;
            Tree<V, ?> tree = vars.get(decl);
            if (tree == null) {
                vars.put(var, node);
                return true;
            }
            return tree.equals(node);
        }
        Val p = (Val)decl;
        V v = node.value();
        if (Objects.equals(v, p.value())) {
            if (node.childCount() == pattern.childCount()) {
                for (int i = 0; i < node.childCount(); ++i) {
                    Object cp;
                    Object cn = node.childAt(i);
                    if (TreePattern.matches(cn, cp = pattern.childAt(i), vars)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public TreeNode<V> expand(Map<Var<V>, Tree<V, ?>> vars) {
        return TreePattern.expand(this._pattern, vars);
    }

    private static <V> TreeNode<V> expand(Tree<Decl<V>, ?> template, Map<Var<V>, Tree<V, ?>> vars) {
        Map<Tree.Path, Var> paths = template.stream().filter(n -> n.value() instanceof Var).collect(Collectors.toMap(Tree::childPath, t -> (Var)t.value()));
        TreeNode<Object> tree = TreeNode.ofTree(template, n -> {
            Object v0;
            if (n instanceof Val) {
                Val val = (Val)n;
                v0 = val.value();
            } else {
                v0 = null;
            }
            return v0;
        });
        paths.forEach((path, decl) -> {
            Tree replacement = (Tree)vars.get(decl);
            if (replacement != null) {
                tree.replaceAtPath((Tree.Path)path, TreeNode.ofTree(replacement));
            } else {
                tree.removeAtPath((Tree.Path)path);
            }
        });
        return tree;
    }

    public int hashCode() {
        return this._pattern.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TreePattern)) return false;
        TreePattern other = (TreePattern)obj;
        if (!this._pattern.equals(other._pattern)) return false;
        return true;
    }

    public String toString() {
        return this._pattern.toParenthesesString();
    }

    public static TreePattern<String> compile(String pattern) {
        return TreePattern.compile(pattern, Function.identity());
    }

    public static <V> TreePattern<V> compile(String pattern, Function<? super String, ? extends V> mapper) {
        return new TreePattern<V>(TreeNode.parse(pattern, v -> Decl.of(v.trim(), mapper)));
    }

    private Object writeReplace() {
        return new SerialProxy(1, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        out.writeObject(this._pattern);
    }

    static Object read(ObjectInput in) throws IOException, ClassNotFoundException {
        TreeNode pattern = (TreeNode)in.readObject();
        return new TreePattern(pattern);
    }

    public record Var<V>(String name) implements Decl<V>,
    Comparable<Var<V>>,
    Serializable
    {
        private static final long serialVersionUID = 2L;

        public Var {
            if (!Names.isIdentifier(name)) {
                throw new IllegalArgumentException(String.format("Variable is not valid identifier: '%s'", name));
            }
        }

        @Override
        public <B> Var<B> map(Function<? super V, ? extends B> mapper) {
            return this;
        }

        @Override
        public int compareTo(Var<V> var) {
            return this.name.compareTo(var.name);
        }

        @Override
        public String toString() {
            return String.format("%s%s", Character.valueOf('$'), this.name);
        }

        static boolean isVar(String name) {
            return !name.isEmpty() && name.charAt(0) == '$';
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Decl<V> {
        public <B> Decl<B> map(Function<? super V, ? extends B> var1);

        public static <V> Decl<V> of(String value, Function<? super String, ? extends V> mapper) {
            return Var.isVar(value) ? new Var(value.substring(1)) : new Val<V>(mapper.apply(ESCAPER.unescape(value)));
        }
    }

    public record Val<V>(V value) implements Decl<V>,
    Serializable
    {
        private static final long serialVersionUID = 2L;

        @Override
        public <B> Val<B> map(Function<? super V, ? extends B> mapper) {
            return new Val<B>(mapper.apply(this.value));
        }

        @Override
        public String toString() {
            return Objects.toString(this.value);
        }
    }
}

