/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.internal.util;

import io.jenetics.util.RandomAdapter;
import java.math.BigInteger;
import java.util.Random;
import java.util.random.RandomGenerator;

public class Randoms {
    private Randoms() {
    }

    public static BigInteger nextBigInteger(BigInteger n, RandomGenerator random) {
        if (n.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException(String.format("n is smaller than one: %d", n));
        }
        BigInteger result = null;
        if (n.bitLength() <= 31) {
            result = BigInteger.valueOf(random.nextInt(n.intValue()));
        } else if (n.bitLength() <= 63) {
            result = BigInteger.valueOf(random.nextLong(n.longValue()));
        } else {
            Random rnd = RandomAdapter.of((RandomGenerator)random);
            while ((result = new BigInteger(n.bitLength(), rnd).mod(n)).compareTo(n) > 0) {
            }
        }
        return result;
    }

    public static BigInteger nextBigInteger(BigInteger min, BigInteger max, RandomGenerator random) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("min >= max: %d > %d.", min, max));
        }
        BigInteger n = max.subtract(min);
        return Randoms.nextBigInteger(n, random).add(min);
    }
}

