/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.moea;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.ext.moea.CrowdedComparator;
import io.jenetics.ext.moea.ElementComparator;
import io.jenetics.ext.moea.ElementDistance;
import io.jenetics.ext.moea.Vec;
import io.jenetics.internal.math.Subset;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.random.RandomGenerator;

public class UFTournamentSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private final Comparator<Phenotype<G, C>> _dominance;
    private final ElementComparator<Phenotype<G, C>> _comparator;
    private final ElementDistance<Phenotype<G, C>> _distance;
    private final ToIntFunction<Phenotype<G, C>> _dimension;

    public UFTournamentSelector(Comparator<? super C> dominance, ElementComparator<? super C> comparator, ElementDistance<? super C> distance, ToIntFunction<? super C> dimension) {
        Objects.requireNonNull(dominance);
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(distance);
        Objects.requireNonNull(dimension);
        this._dominance = (a, b) -> dominance.compare((Object)a.fitness(), (Object)b.fitness());
        this._comparator = comparator.map(Phenotype::fitness);
        this._distance = distance.map(Phenotype::fitness);
        this._dimension = v -> dimension.applyAsInt((Object)v.fitness());
    }

    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        RandomGenerator random = RandomRegistry.random();
        CrowdedComparator<Phenotype<G, C>> cc = new CrowdedComparator<Phenotype<G, C>>(population, opt, this._dominance, this._comparator, this._distance, this._dimension);
        ArrayList<Phenotype> S = new ArrayList<Phenotype>();
        while (S.size() < count) {
            int k = Math.min(2 * count - S.size(), population.size());
            int[] G = Subset.next((int)population.size(), (int)k, (RandomGenerator)random);
            for (int j = 0; j < G.length - 1 && S.size() < count; j += 2) {
                int cmp = cc.compare(G[j], G[j + 1]);
                int p = cmp > 0 ? G[j] : (cmp < 0 ? G[j + 1] : (random.nextBoolean() ? G[j] : G[j + 1]));
                Comparable fitness = ((Phenotype)population.get(p)).fitness();
                List<Phenotype> list = population.stream().filter(pt -> pt.fitness().equals(fitness)).toList();
                S.add(list.get(random.nextInt(list.size())));
            }
        }
        return ISeq.of(S);
    }

    public static <G extends Gene<?, G>, T, V extends Vec<T>> UFTournamentSelector<G, V> ofVec() {
        return new UFTournamentSelector<G, Vec>(Vec::dominance, Vec::compare, Vec::distance, Vec::length);
    }
}

