/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.rewriting;

import io.jenetics.ext.rewriting.TreePattern;
import io.jenetics.ext.util.Tree;
import io.jenetics.internal.util.Hashes;
import java.util.Map;
import java.util.Objects;

public final class TreeMatchResult<V> {
    private final Tree<V, ?> _tree;
    private final Map<TreePattern.Var<V>, Tree<V, ?>> _vars;

    private TreeMatchResult(Tree<V, ?> tree, Map<TreePattern.Var<V>, Tree<V, ?>> vars) {
        this._tree = Objects.requireNonNull(tree);
        this._vars = Map.copyOf(vars);
    }

    public Tree<V, ?> tree() {
        return this._tree;
    }

    public Map<TreePattern.Var<V>, Tree<V, ?>> vars() {
        return this._vars;
    }

    public int hashCode() {
        return Hashes.hash(this._tree, (int)Hashes.hash(this._vars));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TreeMatchResult)) return false;
        TreeMatchResult other = (TreeMatchResult)obj;
        if (!this._tree.equals(other._tree)) return false;
        if (!this._vars.equals(other._vars)) return false;
        return true;
    }

    public String toString() {
        return this._tree.toParenthesesString();
    }

    static <V> TreeMatchResult<V> of(Tree<V, ?> tree, Map<TreePattern.Var<V>, Tree<V, ?>> vars) {
        return new TreeMatchResult<V>(tree, vars);
    }
}

