/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.FlatTree;
import io.jenetics.ext.util.IntFunctionIterator;
import io.jenetics.ext.util.ParenthesesTreeParser;
import io.jenetics.ext.util.SerialProxy;
import io.jenetics.ext.util.Tree;
import io.jenetics.internal.util.SerialIO;
import io.jenetics.util.ISeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class FlatTreeNode<V>
implements FlatTree<V, FlatTreeNode<V>>,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final int NULL_INDEX = -1;
    private final Nodes _nodes;
    private final int _index;

    private FlatTreeNode(Nodes nodes, int index) {
        this._nodes = Objects.requireNonNull(nodes);
        this._index = index;
    }

    private FlatTreeNode(Nodes nodes) {
        this(nodes, 0);
    }

    @Override
    public FlatTreeNode<V> root() {
        return this.nodeAt(0);
    }

    @Override
    public boolean isRoot() {
        return this._index == 0;
    }

    private FlatTreeNode<V> nodeAt(int index) {
        return new FlatTreeNode<V>(this._nodes, index);
    }

    @Override
    public V value() {
        return (V)this._nodes.values[this._index];
    }

    @Override
    public Optional<FlatTreeNode<V>> parent() {
        int index = -1;
        int i = this._index;
        while (--i >= 0 && index == -1) {
            if (!this.isParent(i)) continue;
            index = i;
        }
        return index != -1 ? Optional.of(this.nodeAt(index)) : Optional.empty();
    }

    private boolean isParent(int index) {
        return this._nodes.childCounts[index] > 0 && this._nodes.childOffsets[index] <= this._index && this._nodes.childOffsets[index] + this._nodes.childCounts[index] > this._index;
    }

    @Override
    public FlatTreeNode<V> childAt(int index) {
        if (index < 0 || index >= this.childCount()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.nodeAt(this.childOffset() + index);
    }

    @Override
    public int childCount() {
        return this._nodes.childCounts[this._index];
    }

    @Override
    public int childOffset() {
        return this._nodes.childOffsets[this._index];
    }

    @Override
    public ISeq<FlatTreeNode<V>> flattenedNodes() {
        return (ISeq)this.stream().collect(ISeq.toISeq());
    }

    @Override
    public Iterator<FlatTreeNode<V>> breadthFirstIterator() {
        return this.isRoot() ? new IntFunctionIterator<FlatTreeNode>(this::nodeAt, this._nodes.values.length) : FlatTree.super.breadthFirstIterator();
    }

    @Override
    public Stream<FlatTreeNode<V>> breadthFirstStream() {
        return this.isRoot() ? IntStream.range(0, this._nodes.values.length).mapToObj(this::nodeAt) : FlatTree.super.breadthFirstStream();
    }

    public <B> ISeq<B> map(Function<? super FlatTreeNode<V>, ? extends B> mapper) {
        return (ISeq)this.stream().map(mapper).collect(ISeq.toISeq());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean identical(Tree<?, ?> other) {
        if (other == this) return true;
        if (!(other instanceof FlatTreeNode)) return false;
        FlatTreeNode node = (FlatTreeNode)other;
        if (node._index != this._index) return false;
        if (node._nodes != this._nodes) return false;
        return true;
    }

    @Override
    public <U> U reduce(final U[] neutral, final BiFunction<? super V, ? super U[], ? extends U> reducer) {
        Objects.requireNonNull(neutral);
        Objects.requireNonNull(reducer);
        final class Reducing {
            Reducing() {
            }

            private U reduce(int index) {
                return FlatTreeNode.this._nodes.childCounts[index] == 0 ? reducer.apply(FlatTreeNode.this._nodes.values[index], neutral) : reducer.apply(FlatTreeNode.this._nodes.values[index], this.children(index));
            }

            private U[] children(int index) {
                Object[] values = (Object[])Array.newInstance(neutral.getClass().getComponentType(), FlatTreeNode.this._nodes.childCounts[index]);
                for (int i = 0; i < FlatTreeNode.this._nodes.childCounts[index]; ++i) {
                    values[i] = this.reduce(FlatTreeNode.this._nodes.childOffsets[index] + i);
                }
                return values;
            }
        }
        return this.isEmpty() ? null : (U)new Reducing().reduce(this._index);
    }

    public int hashCode() {
        return Tree.hashCode(this);
    }

    public boolean equals(Object obj) {
        Tree tree;
        FlatTreeNode ftn;
        return obj == this || obj instanceof FlatTreeNode && this.equals(ftn = (FlatTreeNode)obj) || obj instanceof Tree && Tree.equals(tree = (Tree)obj, this);
    }

    private boolean equals(FlatTreeNode<?> tree) {
        return tree._index == this._index && Arrays.equals(tree._nodes.values, this._nodes.values) && Arrays.equals(tree._nodes.childCounts, this._nodes.childCounts) && Arrays.equals(tree._nodes.childOffsets, this._nodes.childOffsets);
    }

    public String toString() {
        return this.toParenthesesString();
    }

    @Override
    public int size() {
        return this.isRoot() ? this._nodes.values.length : this.countChildren(this._index) + 1;
    }

    private int countChildren(int index) {
        int count = this._nodes.childCounts[index];
        for (int i = 0; i < this._nodes.childCounts[index]; ++i) {
            count += this.countChildren(this._nodes.childOffsets[index] + i);
        }
        return count;
    }

    public static <V> FlatTreeNode<V> ofTree(Tree<? extends V, ?> tree) {
        FlatTreeNode ft;
        Objects.requireNonNull(tree);
        if (tree instanceof FlatTreeNode && (ft = (FlatTreeNode)tree).isRoot()) {
            FlatTreeNode result = ft;
            return result;
        }
        int size = tree.size();
        assert (size >= 1);
        Nodes nodes = new Nodes(size);
        int childOffset = 1;
        int index = 0;
        for (Tree node : tree) {
            nodes.values[index] = node.value();
            nodes.childCounts[index] = node.childCount();
            nodes.childOffsets[index] = node.isLeaf() ? -1 : childOffset;
            childOffset += node.childCount();
            ++index;
        }
        assert (index == size);
        return new FlatTreeNode<V>(nodes);
    }

    public static FlatTreeNode<String> parse(String tree) {
        return FlatTreeNode.ofTree(ParenthesesTreeParser.parse(tree, Function.identity()));
    }

    public static <B> FlatTreeNode<B> parse(String tree, Function<? super String, ? extends B> mapper) {
        return FlatTreeNode.ofTree(ParenthesesTreeParser.parse(tree, mapper));
    }

    private Object writeReplace() {
        return new SerialProxy(2, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(ObjectOutput out) throws IOException {
        FlatTreeNode<V> node = this.isRoot() ? this : FlatTreeNode.ofTree(this);
        SerialIO.writeObjectArray((Object[])node._nodes.values, (ObjectOutput)out);
        SerialIO.writeIntArray((int[])node._nodes.childOffsets, (DataOutput)out);
        SerialIO.writeIntArray((int[])node._nodes.childCounts, (DataOutput)out);
    }

    static FlatTreeNode read(ObjectInput in) throws IOException, ClassNotFoundException {
        return new FlatTreeNode(new Nodes(SerialIO.readObjectArray((ObjectInput)in), SerialIO.readIntArray((DataInput)in), SerialIO.readIntArray((DataInput)in)));
    }

    private record Nodes(Object[] values, int[] childOffsets, int[] childCounts) {
        Nodes(int size) {
            this(new Object[size], new int[size], new int[size]);
        }
    }
}

