/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.ParenthesesTrees;
import io.jenetics.ext.util.TreeNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class ParenthesesTreeParser {
    private ParenthesesTreeParser() {
    }

    static List<Token> tokenize(String value) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int pc = 0;
        int pos = 0;
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (ParenthesesTreeParser.isTokenSeparator(c) && pc != 92) {
                tokens.add(new Token(token.toString(), pos));
                tokens.add(new Token(Character.toString(c), i));
                token.setLength(0);
                pos = i;
            } else {
                token.append(c);
            }
            pc = c;
        }
        if (!token.isEmpty()) {
            tokens.add(new Token(token.toString(), pos));
        }
        return tokens;
    }

    private static boolean isTokenSeparator(char c) {
        return switch (c) {
            case '(', ')', ',' -> true;
            default -> false;
        };
    }

    static <B> TreeNode<B> parse(String value, Function<? super String, ? extends B> mapper) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(mapper);
        TreeNode<TreeNode<Object>> root = TreeNode.of();
        ArrayDeque<TreeNode<TreeNode<Object>>> parents = new ArrayDeque<TreeNode<TreeNode<Object>>>();
        TreeNode<TreeNode<Object>> current = root;
        block10: for (Token token : ParenthesesTreeParser.tokenize(value.trim())) {
            switch (token.seq) {
                case "(": {
                    if (current == null) {
                        throw new IllegalArgumentException(String.format("Illegal parentheses tree string: '%s'.", value));
                    }
                    TreeNode<TreeNode<Object>> tn1 = TreeNode.of();
                    current.attach((TreeNode<Object>)tn1);
                    parents.push(current);
                    current = tn1;
                    continue block10;
                }
                case ",": {
                    if (parents.isEmpty()) {
                        throw new IllegalArgumentException(String.format("Expect '(' at position %d.", token.pos));
                    }
                    TreeNode tn2 = TreeNode.of();
                    assert (parents.peek() != null);
                    ((TreeNode)parents.peek()).attach(tn2);
                    current = tn2;
                    continue block10;
                }
                case ")": {
                    if (parents.isEmpty()) {
                        throw new IllegalArgumentException(String.format("Unbalanced parentheses at position %d.", token.pos));
                    }
                    current = (TreeNode<TreeNode<Object>>)parents.pop();
                    if (!parents.isEmpty()) continue block10;
                    current = null;
                    continue block10;
                }
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("More than one root element at pos %d: '%s'.", token.pos, value));
            }
            if (current.value() != null) continue;
            current.value((TreeNode<Object>)mapper.apply(ParenthesesTrees.unescape(token.seq)));
        }
        if (!parents.isEmpty()) {
            throw new IllegalArgumentException("Unbalanced parentheses: " + value);
        }
        return root;
    }

    record Token(String seq, int pos) {
    }
}

