/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

final class TreeNodeBreadthFirstIterator<V, T extends Tree<V, T>>
implements Iterator<T> {
    private final Queue<Iterator<T>> _queue = new ArrayDeque<Iterator<T>>();

    TreeNodeBreadthFirstIterator(T root) {
        Objects.requireNonNull(root);
        this._queue.add(List.of(root).iterator());
    }

    @Override
    public boolean hasNext() {
        Iterator<T> peek = this._queue.peek();
        return peek != null && peek.hasNext();
    }

    @Override
    public T next() {
        Iterator children;
        Iterator<T> it = this._queue.peek();
        if (it == null) {
            throw new NoSuchElementException("No next element.");
        }
        Tree node = (Tree)it.next();
        if (!it.hasNext()) {
            this._queue.poll();
        }
        if ((children = node.childIterator()).hasNext()) {
            this._queue.add(children);
        }
        return (T)node;
    }
}

