/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.ext.util;

import io.jenetics.ext.util.Tree;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

final class TreeNodePostorderIterator<V, T extends Tree<V, T>>
implements Iterator<T> {
    private T _root;
    private final Iterator<T> _children;
    private Iterator<T> _subtree;

    TreeNodePostorderIterator(T root) {
        this._root = (Tree)Objects.requireNonNull(root);
        this._children = this._root.childIterator();
        this._subtree = Collections.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        return this._root != null;
    }

    @Override
    public T next() {
        Tree result;
        if (this._subtree.hasNext()) {
            result = (Tree)this._subtree.next();
        } else if (this._children.hasNext()) {
            this._subtree = new TreeNodePostorderIterator<V, Tree>((Tree)this._children.next());
            result = (Tree)this._subtree.next();
        } else {
            result = this._root;
            this._root = null;
        }
        return (T)result;
    }
}

