/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import com.google.common.collect.ImmutableSet;
import io.jenkins.tools.incrementals.maven.DetectIndent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="incrementalify", requiresDirectInvocation=true, aggregator=true)
public class IncrementalifyMojo
extends AbstractVersionsUpdaterMojo {
    private static final String MINIMUM_JENKINS_PARENT = "1.47";
    private static final String MINIMUM_PLUGIN_PARENT = "3.10";
    public static final String JENKINS_POM = "org.jenkins-ci:jenkins:pom";
    public static final String PLUGIN_POM = "org.jenkins-ci.plugins:plugin:pom";
    private static final Set<String> PARENT_DEPENDENCIES = ImmutableSet.of((Object)"org.jenkins-ci:jenkins:pom", (Object)"org.jenkins-ci.plugins:plugin:pom");
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactVersions gclmeVersions;
        VersionRange any;
        File dotMvn = new File(this.project.getBasedir(), ".mvn");
        File extensionsXml = new File(dotMvn, "extensions.xml");
        if (extensionsXml.isFile()) {
            throw new MojoFailureException("Editing an existing " + extensionsXml + " is not yet supported");
        }
        try {
            any = VersionRange.createFromVersionSpec((String)"[0,)");
            gclmeVersions = this.getHelper().lookupArtifactVersions(this.getHelper().createDependencyArtifact("io.jenkins.tools.incrementals", "git-changelist-maven-extension", any, "type", null, null), true);
        }
        catch (ArtifactMetadataRetrievalException | InvalidVersionSpecificationException x) {
            throw new MojoExecutionException(x.getMessage(), (Exception)x);
        }
        ArtifactVersion gclmeNewestVersion = gclmeVersions.getNewestVersion(any, false);
        super.execute();
        this.project.getProperties().setProperty("dollar", "$");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.codehaus.mojo", (String)"versions-maven-plugin", (String)"2.5"), (String)"set", (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"newVersion", (String)"${dollar}{revision}${dollar}{changelist}"), MojoExecutor.element((String)"generateBackupPoms", (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        File mavenConfig = new File(dotMvn, "maven.config");
        try {
            String existing = mavenConfig.isFile() ? FileUtils.readFileToString((File)mavenConfig, (String)"UTF-8") : "";
            dotMvn.mkdirs();
            FileUtils.writeStringToFile((File)mavenConfig, (String)("-Pconsume-incrementals\n-Pmight-produce-incrementals\n" + existing), (String)"UTF-8");
            try (InputStream is = IncrementalifyMojo.class.getResourceAsStream("prototype-extensions.xml");){
                FileUtils.writeStringToFile((File)extensionsXml, (String)IOUtils.toString((InputStream)is).replace("@VERSION@", gclmeNewestVersion.toString()));
            }
        }
        catch (IOException x) {
            throw new MojoExecutionException("failed to update " + dotMvn, (Exception)x);
        }
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        String version = PomHelper.getProjectVersion((ModifiedPomXMLEventReader)pom);
        Matcher m = Pattern.compile("(.+)-SNAPSHOT").matcher(version);
        if (!m.matches()) {
            throw new MojoFailureException("Unexpected version: " + version);
        }
        String origTag = this.project.getScm().getTag();
        if (!origTag.equals("HEAD")) {
            throw new MojoFailureException("Unexpected tag: " + origTag);
        }
        Artifact parent = PomHelper.getProjectParent((ModifiedPomXMLEventReader)pom, (VersionsHelper)this.getHelper());
        if (parent == null) {
            throw new MojoFailureException("No <parent> found");
        }
        if (!PARENT_DEPENDENCIES.contains(parent.getDependencyConflictId())) {
            throw new MojoFailureException("Unexpected <parent> " + parent);
        }
        String minimum_parent = parent.getDependencyConflictId().equals(JENKINS_POM) ? MINIMUM_JENKINS_PARENT : MINIMUM_PLUGIN_PARENT;
        if (new ComparableVersion(parent.getVersion()).compareTo(new ComparableVersion(minimum_parent)) < 0) {
            PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)minimum_parent);
        }
        this.prependProperty(pom, "changelist", "-SNAPSHOT");
        this.prependProperty(pom, "revision", m.group(1));
        PomHelper.setProjectValue((ModifiedPomXMLEventReader)pom, (String)"/project/scm/tag", (String)"${scmTag}");
    }

    private void prependProperty(ModifiedPomXMLEventReader pom, String name, String value) throws XMLStreamException, MojoFailureException {
        Stack<String> stack = new Stack<String>();
        pom.rewind();
        boolean found = false;
        while (pom.hasNext()) {
            XMLEvent event = pom.nextEvent();
            if (event.isStartElement()) {
                stack.push(event.asStartElement().getName().getLocalPart());
                if (!stack.equals(Arrays.asList("project", "properties"))) continue;
                pom.mark(0);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (stack.equals(Arrays.asList("project", "properties"))) {
                pom.mark(1);
                found = true;
                String orig = pom.getBetween(0, 1);
                DetectIndent.Indent indent = new DetectIndent().detect(orig);
                pom.replaceBetween(0, 1, "\n" + indent.getIndent() + "<" + name + ">" + value + "</" + name + ">" + orig);
                pom.clearMark(0);
                pom.clearMark(1);
            }
            stack.pop();
        }
        if (!found) {
            throw new MojoFailureException("failed to find <properties>");
        }
    }
}

