/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import io.jenkins.tools.incrementals.lib.UpdateChecker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="update", requiresDirectInvocation=true)
public class UpdateMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="updateNonincremental", defaultValue="true")
    private boolean updateNonincremental;
    @Parameter(property="branch", defaultValue="master")
    private String branch;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<MavenArtifactRepository> repos;

    @Inject
    public UpdateMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            List dependencies;
            DependencyManagement dependencyManagement;
            UpdateChecker checker = new UpdateChecker(message -> this.getLog().info((CharSequence)message), Arrays.asList("https://repo.jenkins-ci.org/releases/", "https://repo.jenkins-ci.org/incrementals/"));
            if (this.isProcessingDependencyManagement() && (dependencyManagement = this.getProject().getDependencyManagement()) != null) {
                this.update(pom, dependencyManagement.getDependencies(), checker);
            }
            if (this.isProcessingDependencies() && (dependencies = this.getProject().getDependencies()) != null) {
                this.update(pom, dependencies, checker);
            }
            this.updateProperties(pom, checker);
        }
        catch (XMLStreamException | MojoExecutionException | MojoFailureException x) {
            throw x;
        }
        catch (Exception x) {
            throw new MojoExecutionException("Update failed", x);
        }
    }

    private void update(ModifiedPomXMLEventReader pom, List<Dependency> dependencies, UpdateChecker checker) throws Exception {
        for (Dependency dep : dependencies) {
            String artifactId;
            Artifact art = this.toArtifact(dep);
            if (!this.isIncluded(art)) {
                this.getLog().debug((CharSequence)("Skipping " + this.toString(dep)));
                continue;
            }
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Skipping reactor dep " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            if (ArtifactUtils.isSnapshot((String)version)) {
                this.getLog().info((CharSequence)("Skipping snapshot dep " + this.toString(dep)));
                continue;
            }
            if (!this.updateNonincremental && !UpdateMojo.isIncremental(version)) {
                this.getLog().debug((CharSequence)("Skipping nonincremental dep " + this.toString(dep)));
                continue;
            }
            String groupId = art.getGroupId();
            UpdateChecker.VersionAndRepo result = checker.find(groupId, artifactId = art.getArtifactId(), version, this.branch);
            if (result == null) {
                this.getLog().info((CharSequence)("No update found for " + this.toString(dep)));
                continue;
            }
            this.getLog().info((CharSequence)("Can update dependency " + this.toString(dep) + " to " + result.version));
            PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)groupId, (String)artifactId, (String)version, (String)result.version.toString(), (Model)this.getProject().getModel());
        }
    }

    private void updateProperties(ModifiedPomXMLEventReader pom, UpdateChecker checker) throws Exception {
        block0: for (Map.Entry entry : this.getHelper().getVersionPropertiesMap(VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(this.getProject()).build()).entrySet()) {
            Property property = (Property)entry.getKey();
            String name = property.getName();
            PropertyVersions versions = (PropertyVersions)entry.getValue();
            String version = this.getProject().getProperties().getProperty(name);
            if (version == null) continue;
            if (!this.updateNonincremental && !UpdateMojo.isIncremental(version)) {
                this.getLog().debug((CharSequence)("Skipping nonincremental ${" + name + "}=" + version));
                continue;
            }
            List<String> ga = null;
            for (ArtifactAssociation assn : versions.getAssociations()) {
                Artifact art = assn.getArtifact();
                if (!this.isIncluded(art)) {
                    this.getLog().info((CharSequence)("Skipping update of ${" + name + "} because it is used in excluded " + art));
                    continue block0;
                }
                List<String> candidateGA = Arrays.asList(art.getGroupId(), art.getArtifactId());
                if (ga != null && !ga.equals(candidateGA)) {
                    this.getLog().info((CharSequence)("Skipping update of ${" + name + "} because it is used in both " + ga + " and " + candidateGA));
                    continue block0;
                }
                ga = candidateGA;
            }
            if (ga == null) {
                this.getLog().info((CharSequence)("No artifacts using ${" + name + "}, skipping"));
                continue;
            }
            UpdateChecker.VersionAndRepo result = checker.find((String)ga.get(0), (String)ga.get(1), version, this.branch);
            if (result == null) {
                this.getLog().info((CharSequence)("No update found for: " + (String)ga.get(0) + ":" + ga.get(1) + ":" + version));
                continue;
            }
            this.getLog().info((CharSequence)("Can update ${" + name + "} to " + result.version));
            PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)pom, (String)versions.getProfileId(), (String)name, (String)result.version.toString());
        }
    }

    private static boolean isIncremental(String version) {
        return version.matches(".+-rc[0-9]+[.][0-9a-f]{12}");
    }
}

