/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import org.apache.maven.model.Dependency;

public class PluginRef {
    @CheckForNull
    private String artifactId;
    @CheckForNull
    private String groupId;
    @CheckForNull
    private String tag;
    @CheckForNull
    private String version;
    private boolean incrementals;
    @CheckForNull
    private String comment;
    @CheckForNull
    private String githubUser;
    @CheckForNull
    private String githubBranch;

    private PluginRef() {
    }

    @CheckForNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @CheckForNull
    public String getGroupId() {
        return this.groupId;
    }

    @CheckForNull
    public String getTag() {
        return this.tag;
    }

    @CheckForNull
    public String getVersion() {
        return this.version;
    }

    public boolean isIncrementals() {
        return this.incrementals;
    }

    @CheckForNull
    public String getComment() {
        return this.comment;
    }

    public boolean isComment() {
        return this.comment != null;
    }

    @CheckForNull
    public String getGithubUser() {
        return this.githubUser;
    }

    @CheckForNull
    public String getGithubBranch() {
        return this.githubBranch;
    }

    public String toString() {
        if (this.comment != null) {
            return "comment: " + this.comment;
        }
        return this.artifactId + (this.version != null ? ":" + this.version : "");
    }

    @NonNull
    public String toPluginsTxtString() {
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isIncrementals()) {
            String res = String.format("%s:%s;%s;%s", this.artifactId, "incrementals", this.groupId, this.version);
            if (this.githubUser != null) {
                res = res + ";" + this.githubUser;
            }
            if (this.githubBranch != null) {
                res = res + ";" + this.githubBranch;
            }
            return res;
        }
        String label = this.version != null ? this.version : this.tag;
        return this.artifactId + (label != null ? ":" + label : "");
    }

    @NonNull
    public static PluginRef forComment(@NonNull String line) throws IOException {
        PluginRef ref = new PluginRef();
        ref.comment = line;
        return ref;
    }

    public void setVersion(@NonNull String version) {
        this.version = version;
    }

    @NonNull
    public static PluginRef fromString(@NonNull String str) throws IOException {
        String[] entries = str.split(":");
        if (entries.length == 0) {
            throw new IOException("Version string is corrupted: " + str);
        }
        PluginRef plugin = new PluginRef();
        plugin.artifactId = entries[0];
        if (entries.length > 1) {
            String[] versionEntries = entries[1].split(";");
            switch (versionEntries[0]) {
                case "latest": {
                    plugin.tag = "latest";
                    break;
                }
                case "experimental": {
                    plugin.tag = "experimental";
                    break;
                }
                case "incrementals": {
                    if (versionEntries.length < 3 || versionEntries.length > 5) {
                        throw new IOException("Wrong incrementals format: " + str);
                    }
                    plugin.groupId = versionEntries[1];
                    plugin.version = versionEntries[2];
                    if (versionEntries.length == 4) {
                        plugin.githubBranch = versionEntries[3];
                    } else if (versionEntries.length == 5) {
                        plugin.githubUser = versionEntries[3];
                        plugin.githubBranch = versionEntries[4];
                    }
                    plugin.incrementals = true;
                    break;
                }
                default: {
                    plugin.version = versionEntries[0];
                }
            }
        }
        return plugin;
    }

    @NonNull
    public Dependency toDependency() {
        Dependency dep = new Dependency();
        dep.setArtifactId(this.artifactId);
        dep.setGroupId(this.groupId);
        dep.setVersion(this.version);
        return dep;
    }
}

