/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation;

import io.jexxa.adapterapi.interceptor.AroundInterceptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class InvocationContext {
    private final Iterator<AroundInterceptor> currentInterceptor;
    private final Object targetObject;

    protected InvocationContext(Object targetObject, Collection<AroundInterceptor> interceptors) {
        this.currentInterceptor = Objects.requireNonNull(interceptors).iterator();
        this.targetObject = targetObject;
    }

    public abstract void invoke();

    public abstract Method getMethod();

    public Object getTarget() {
        return this.targetObject;
    }

    public <T> T getTarget(Class<T> clazz) {
        return clazz.cast(this.getTarget());
    }

    public abstract Object[] getArgs();

    public abstract Object getReturnValue();

    public <T> T getReturnValue(Class<T> clazz) {
        return clazz.cast(this.getReturnValue());
    }

    public Class<?>[] getArgTypes() {
        return (Class[])Stream.of(this.getArgs()).map(Object::getClass).toArray(Class[]::new);
    }

    public void proceed() {
        if (this.currentInterceptor.hasNext()) {
            this.currentInterceptor.next().around(this);
        } else {
            this.invoke();
        }
    }
}

