/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation.transaction;

import io.jexxa.adapterapi.JexxaContext;
import io.jexxa.adapterapi.invocation.transaction.TransactionHandler;
import java.util.ArrayList;
import java.util.List;

public class TransactionManager {
    private static final TransactionManager INSTANCE = new TransactionManager();
    private final List<TransactionHandler> transactionHandlerList = new ArrayList<TransactionHandler>();

    public static TransactionManager getInstance() {
        return INSTANCE;
    }

    public static void registerTransactionHandler(TransactionHandler transactionHandler) {
        TransactionManager.INSTANCE.transactionHandlerList.add(transactionHandler);
    }

    public static void initTransaction() {
        TransactionManager.INSTANCE.transactionHandlerList.forEach(TransactionHandler::initTransaction);
    }

    public static void closeTransaction() {
        TransactionManager.INSTANCE.transactionHandlerList.forEach(TransactionHandler::closeTransaction);
    }

    public static void rollback() {
        TransactionManager.INSTANCE.transactionHandlerList.forEach(TransactionHandler::rollback);
    }

    public static void clear() {
        TransactionManager.getInstance().transactionHandlerList.clear();
    }

    private TransactionManager() {
        JexxaContext.registerInitHandler(TransactionManager::clear);
        JexxaContext.registerCleanupHandler(TransactionManager::clear);
    }
}

