/*
 * Decompiled with CFR 0.152.
 */
package io.jobial.scase.pulsar;

import io.jobial.scase.marshalling.Marshaller;
import io.jobial.scase.marshalling.Unmarshaller;
import io.jobial.scase.pulsar.PulsarMessageDestinationServiceConfiguration;
import io.jobial.scase.pulsar.PulsarMessageHandlerServiceConfiguration;
import io.jobial.scase.pulsar.PulsarMessageSourceServiceConfiguration;
import io.jobial.scase.pulsar.PulsarMessageSourceServiceConfiguration$;
import io.jobial.scase.pulsar.PulsarRequestResponseServiceConfiguration;
import io.jobial.scase.pulsar.PulsarStreamServiceConfiguration;
import io.jobial.scase.pulsar.PulsarStreamServiceWithErrorTopicConfiguration;
import java.time.Instant;
import java.util.UUID;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class PulsarServiceConfiguration$ {
    public static final PulsarServiceConfiguration$ MODULE$ = new PulsarServiceConfiguration$();

    public <REQ, RESP> PulsarRequestResponseServiceConfiguration<REQ, RESP> requestResponse(String requestTopic, Option<String> responseTopicOverride, Option<FiniteDuration> batchingMaxPublishDelay, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, String subscriptionName, Marshaller<REQ> evidence$43, Unmarshaller<REQ> evidence$44, Marshaller<RESP> evidence$45, Unmarshaller<RESP> evidence$46, Marshaller<Either<Throwable, RESP>> responseMarshaller, Unmarshaller<Either<Throwable, RESP>> responseUnmarshaller) {
        return new PulsarRequestResponseServiceConfiguration<REQ, RESP>(requestTopic, (Either<String, Regex>)package$.MODULE$.Left().apply((Object)requestTopic), responseTopicOverride, batchingMaxPublishDelay, patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, subscriptionName, evidence$43, evidence$44, evidence$45, evidence$46, responseMarshaller, responseUnmarshaller);
    }

    public <REQ, RESP> PulsarRequestResponseServiceConfiguration<REQ, RESP> requestResponse(Either<String, Regex> requestTopic, String subscriptionName, Marshaller<REQ> evidence$47, Unmarshaller<REQ> evidence$48, Marshaller<RESP> evidence$49, Unmarshaller<RESP> evidence$50, Marshaller<Either<Throwable, RESP>> responseMarshaller, Unmarshaller<Either<Throwable, RESP>> responseUnmarshaller) {
        String string;
        Either<String, Regex> either = requestTopic;
        if (either instanceof Right) {
            Right right = (Right)either;
            Regex r = (Regex)right.value();
            string = r.toString();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            String l = (String)left.value();
            string = l.toString();
        } else {
            throw new MatchError(either);
        }
        return new PulsarRequestResponseServiceConfiguration<REQ, RESP>(string, requestTopic, (Option<String>)None$.MODULE$, (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis()), (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), (Option<SubscriptionInitialPosition>)new Some((Object)SubscriptionInitialPosition.Latest), (Option<Instant>)None$.MODULE$, subscriptionName, evidence$47, evidence$48, evidence$49, evidence$50, responseMarshaller, responseUnmarshaller);
    }

    public <REQ, RESP> Option<String> requestResponse$default$2() {
        return None$.MODULE$;
    }

    public <REQ, RESP> Option<FiniteDuration> requestResponse$default$3() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis());
    }

    public <REQ, RESP> Option<FiniteDuration> requestResponse$default$4() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
    }

    public <REQ, RESP> Option<SubscriptionInitialPosition> requestResponse$default$5() {
        return new Some((Object)SubscriptionInitialPosition.Latest);
    }

    public <REQ, RESP> Option<Instant> requestResponse$default$6() {
        return None$.MODULE$;
    }

    public <REQ, RESP> String requestResponse$default$7() {
        return new StringBuilder(13).append("subscription-").append(UUID.randomUUID()).toString();
    }

    public <REQ, RESP> PulsarStreamServiceConfiguration<REQ, RESP> stream(String requestTopic, String responseTopic, Option<FiniteDuration> batchingMaxPublishDelay, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, Marshaller<REQ> evidence$51, Unmarshaller<REQ> evidence$52, Marshaller<RESP> evidence$53, Unmarshaller<RESP> evidence$54, Marshaller<Either<Throwable, RESP>> responseMarshaller, Unmarshaller<Either<Throwable, RESP>> responseUnmarshaller) {
        return new PulsarStreamServiceConfiguration<REQ, RESP>(requestTopic, requestTopic, responseTopic, batchingMaxPublishDelay, patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, evidence$51, evidence$52, evidence$53, evidence$54, responseMarshaller, responseUnmarshaller);
    }

    public <REQ, RESP> PulsarStreamServiceConfiguration<REQ, RESP> stream(String requestTopic, String responseTopic, Marshaller<REQ> evidence$55, Unmarshaller<REQ> evidence$56, Marshaller<RESP> evidence$57, Unmarshaller<RESP> evidence$58, Marshaller<Either<Throwable, RESP>> responseMarshaller, Unmarshaller<Either<Throwable, RESP>> responseUnmarshaller) {
        return this.stream(requestTopic, responseTopic, (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis()), (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), (Option<SubscriptionInitialPosition>)new Some((Object)SubscriptionInitialPosition.Latest), (Option<Instant>)None$.MODULE$, evidence$55, evidence$56, evidence$57, evidence$58, responseMarshaller, responseUnmarshaller);
    }

    public <REQ, RESP> PulsarStreamServiceWithErrorTopicConfiguration<REQ, RESP> stream(String requestTopic, String responseTopic, String errorTopic, Option<FiniteDuration> batchingMaxPublishDelay, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, Marshaller<REQ> evidence$59, Unmarshaller<REQ> evidence$60, Marshaller<RESP> evidence$61, Unmarshaller<RESP> evidence$62, Marshaller<Throwable> errorMarshaller, Unmarshaller<Throwable> errorUnmarshaller) {
        return new PulsarStreamServiceWithErrorTopicConfiguration<REQ, RESP>(requestTopic, requestTopic, responseTopic, errorTopic, batchingMaxPublishDelay, evidence$59, evidence$60, evidence$61, evidence$62, errorMarshaller, errorUnmarshaller);
    }

    public <REQ, RESP> Option<FiniteDuration> stream$default$4() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis());
    }

    public <REQ, RESP> Option<FiniteDuration> stream$default$5() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
    }

    public <REQ, RESP> Option<SubscriptionInitialPosition> stream$default$6() {
        return new Some((Object)SubscriptionInitialPosition.Latest);
    }

    public <REQ, RESP> Option<Instant> stream$default$7() {
        return None$.MODULE$;
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(Either<String, Regex> requestTopic, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, String subscriptionName, Marshaller<M> evidence$63, Unmarshaller<M> evidence$64) {
        return new PulsarMessageHandlerServiceConfiguration<M>(subscriptionName, requestTopic, patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, subscriptionName, evidence$63, evidence$64);
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(String requestTopic, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, String subscriptionName, Marshaller<M> evidence$65, Unmarshaller<M> evidence$66) {
        return new PulsarMessageHandlerServiceConfiguration<M>(requestTopic, (Either<String, Regex>)package$.MODULE$.Left().apply((Object)requestTopic), patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, subscriptionName, evidence$65, evidence$66);
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(Regex requestTopic, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, String subscriptionName, Marshaller<M> evidence$67, Unmarshaller<M> evidence$68) {
        return new PulsarMessageHandlerServiceConfiguration<M>(requestTopic.toString(), (Either<String, Regex>)package$.MODULE$.Right().apply((Object)requestTopic), patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, subscriptionName, evidence$67, evidence$68);
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(Regex requestTopic, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, String subscriptionName, Marshaller<M> evidence$69, Unmarshaller<M> evidence$70) {
        return new PulsarMessageHandlerServiceConfiguration<M>(requestTopic.toString(), (Either<String, Regex>)package$.MODULE$.Right().apply((Object)requestTopic), (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), subscriptionInitialPosition, subscriptionInitialPublishTime, subscriptionName, evidence$69, evidence$70);
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(Regex requestTopic, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Marshaller<M> evidence$71, Unmarshaller<M> evidence$72) {
        return new PulsarMessageHandlerServiceConfiguration<M>(requestTopic.toString(), (Either<String, Regex>)package$.MODULE$.Right().apply((Object)requestTopic), (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), subscriptionInitialPosition, (Option<Instant>)None$.MODULE$, new StringBuilder(13).append("subscription-").append(UUID.randomUUID()).toString(), evidence$71, evidence$72);
    }

    public <M> PulsarMessageHandlerServiceConfiguration<M> handler(Regex requestTopic, Marshaller<M> evidence$73, Unmarshaller<M> evidence$74) {
        return new PulsarMessageHandlerServiceConfiguration<M>(requestTopic.toString(), (Either<String, Regex>)package$.MODULE$.Right().apply((Object)requestTopic), (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), (Option<SubscriptionInitialPosition>)new Some((Object)SubscriptionInitialPosition.Latest), (Option<Instant>)None$.MODULE$, new StringBuilder(13).append("subscription-").append(UUID.randomUUID()).toString(), evidence$73, evidence$74);
    }

    public <M> Option<FiniteDuration> handler$default$2() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
    }

    public <M> Option<SubscriptionInitialPosition> handler$default$3() {
        return new Some((Object)SubscriptionInitialPosition.Latest);
    }

    public <M> Option<Instant> handler$default$4() {
        return None$.MODULE$;
    }

    public <M> String handler$default$5() {
        return new StringBuilder(13).append("subscription-").append(UUID.randomUUID()).toString();
    }

    public <M> PulsarMessageSourceServiceConfiguration<M> source(Either<String, Regex> sourceTopic, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, Unmarshaller<M> evidence$75) {
        return new PulsarMessageSourceServiceConfiguration<M>(sourceTopic, patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, PulsarMessageSourceServiceConfiguration$.MODULE$.$lessinit$greater$default$5(), evidence$75);
    }

    public <M> PulsarMessageSourceServiceConfiguration<M> source(String sourceTopic, Option<FiniteDuration> patternAutoDiscoveryPeriod, Option<SubscriptionInitialPosition> subscriptionInitialPosition, Option<Instant> subscriptionInitialPublishTime, Unmarshaller<M> evidence$76) {
        return new PulsarMessageSourceServiceConfiguration<M>((Either<String, Regex>)package$.MODULE$.Left().apply((Object)sourceTopic), patternAutoDiscoveryPeriod, subscriptionInitialPosition, subscriptionInitialPublishTime, PulsarMessageSourceServiceConfiguration$.MODULE$.$lessinit$greater$default$5(), evidence$76);
    }

    public <M> PulsarMessageSourceServiceConfiguration<M> source(Either<String, Regex> sourceTopic, String subscriptionName, Unmarshaller<M> evidence$77) {
        return new PulsarMessageSourceServiceConfiguration<M>(sourceTopic, (Option<FiniteDuration>)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), (Option<SubscriptionInitialPosition>)new Some((Object)SubscriptionInitialPosition.Latest), (Option<Instant>)None$.MODULE$, subscriptionName, evidence$77);
    }

    public <M> Option<FiniteDuration> source$default$2() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
    }

    public <M> Option<SubscriptionInitialPosition> source$default$3() {
        return new Some((Object)SubscriptionInitialPosition.Latest);
    }

    public <M> Option<Instant> source$default$4() {
        return None$.MODULE$;
    }

    public <M> PulsarMessageDestinationServiceConfiguration<M> destination(String topic, Option<FiniteDuration> batchingMaxPublishDelay, boolean blockIfQueueFull, Marshaller<M> evidence$78) {
        return new PulsarMessageDestinationServiceConfiguration<M>(topic, batchingMaxPublishDelay, blockIfQueueFull, evidence$78);
    }

    public <M> Option<FiniteDuration> destination$default$2() {
        return new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis());
    }

    public <M> boolean destination$default$3() {
        return true;
    }

    private PulsarServiceConfiguration$() {
    }
}

