/*
 * Decompiled with CFR 0.152.
 */
package io.jobial.scase.pulsar.javadsl;

import cats.effect.IO;
import io.jobial.scase.core.RequestHandler;
import io.jobial.scase.core.javadsl.JavaUtils;
import io.jobial.scase.core.javadsl.ReceiverClient;
import io.jobial.scase.core.javadsl.SenderClient;
import io.jobial.scase.core.javadsl.Service;
import io.jobial.scase.pulsar.javadsl.PulsarContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import scala.util.Either;

public class PulsarStreamServiceConfiguration<REQ, RESP> {
    io.jobial.scase.pulsar.PulsarStreamServiceConfiguration config;

    PulsarStreamServiceConfiguration(io.jobial.scase.pulsar.PulsarStreamServiceConfiguration<REQ, RESP> pulsarStreamServiceConfiguration) {
        this.config = pulsarStreamServiceConfiguration;
    }

    public CompletableFuture<Service> service(RequestHandler<IO, REQ, RESP> requestHandler, PulsarContext pulsarContext) throws ExecutionException, InterruptedException {
        return JavaUtils.service((Object)this.config.service(requestHandler, JavaUtils.concurrent, JavaUtils.timer, pulsarContext.getContext()));
    }

    public CompletableFuture<Service> service(RequestHandler<IO, REQ, RESP> requestHandler) throws ExecutionException, InterruptedException {
        return this.service(requestHandler, new PulsarContext());
    }

    public CompletableFuture<SenderClient<REQ>> senderClient(PulsarContext pulsarContext) throws ExecutionException, InterruptedException {
        return JavaUtils.senderClient(this.config.senderClient(JavaUtils.concurrent, JavaUtils.timer, pulsarContext.getContext()));
    }

    public CompletableFuture<SenderClient<REQ>> senderClient() throws ExecutionException, InterruptedException {
        return this.senderClient(new PulsarContext());
    }

    public CompletableFuture<ReceiverClient<Either<Throwable, RESP>>> receiverClient(PulsarContext pulsarContext) throws ExecutionException, InterruptedException {
        return JavaUtils.receiverClient(this.config.receiverClient(JavaUtils.concurrent, JavaUtils.timer, pulsarContext.getContext()));
    }

    public CompletableFuture<ReceiverClient<Either<Throwable, RESP>>> receiverClient() throws ExecutionException, InterruptedException {
        return this.receiverClient(new PulsarContext());
    }
}

