/*
 * Decompiled with CFR 0.152.
 */
package io.jobial.scase.tools.endpoint;

import cats.Applicative;
import cats.Monad;
import cats.Parallel;
import cats.effect.Bracket;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.effect.concurrent.MVar;
import cats.implicits$;
import cats.kernel.Eq;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.jobial.scase.core.MessageHandler;
import io.jobial.scase.core.impl.CatsUtils;
import io.jobial.scase.core.impl.CatsUtils$IterableSequenceSyntax$;
import io.jobial.scase.jms.JMSServiceConfiguration$;
import io.jobial.scase.logging.Logging;
import io.jobial.scase.marshalling.Marshaller;
import io.jobial.scase.marshalling.Unmarshaller;
import io.jobial.scase.pulsar.PulsarServiceConfiguration$;
import io.jobial.scase.tibrv.TibrvServiceConfiguration$;
import io.jobial.scase.tools.endpoint.ActiveMQEndpoint;
import io.jobial.scase.tools.endpoint.Endpoint;
import io.jobial.scase.tools.endpoint.PulsarEndpoint;
import io.jobial.scase.tools.endpoint.TibrvEndpoint;
import io.lemonlabs.uri.Uri;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.jms.Destination;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.util.Either;

public final class Endpoint$
implements CatsUtils,
Logging {
    public static final Endpoint$ MODULE$ = new Endpoint$();
    private static final Some<SubscriptionInitialPosition> defaultSubscriptionInitialPosition;
    private static transient Logger logger;
    private static volatile CatsUtils$IterableSequenceSyntax$ IterableSequenceSyntax$module;
    private static volatile transient boolean bitmap$trans$0;

    static {
        CatsUtils.$init$((CatsUtils)MODULE$);
        LazyLogging.$init$((LazyLogging)MODULE$);
        Logging.$init$((Logging)MODULE$);
        defaultSubscriptionInitialPosition = new Some((Object)SubscriptionInitialPosition.Earliest);
    }

    public <F> F trace(Function0<String> msg, Sync<F> evidence$1) {
        return (F)Logging.trace$((Logging)this, msg, evidence$1);
    }

    public <F> F trace(Function0<String> msg, Throwable t, Sync<F> evidence$2) {
        return (F)Logging.trace$((Logging)this, msg, (Throwable)t, evidence$2);
    }

    public <F> F debug(Function0<String> msg, Sync<F> evidence$3) {
        return (F)Logging.debug$((Logging)this, msg, evidence$3);
    }

    public <F> F debug(Function0<String> msg, Throwable t, Sync<F> evidence$4) {
        return (F)Logging.debug$((Logging)this, msg, (Throwable)t, evidence$4);
    }

    public <F> F info(Function0<String> msg, Sync<F> evidence$5) {
        return (F)Logging.info$((Logging)this, msg, evidence$5);
    }

    public <F> F info(Function0<String> msg, Throwable t, Sync<F> evidence$6) {
        return (F)Logging.info$((Logging)this, msg, (Throwable)t, evidence$6);
    }

    public <F> F warn(Function0<String> msg, Sync<F> evidence$7) {
        return (F)Logging.warn$((Logging)this, msg, evidence$7);
    }

    public <F> F warn(Function0<String> msg, Throwable t, Sync<F> evidence$8) {
        return (F)Logging.warn$((Logging)this, msg, (Throwable)t, evidence$8);
    }

    public <F> F error(Function0<String> msg, Sync<F> evidence$9) {
        return (F)Logging.error$((Logging)this, msg, evidence$9);
    }

    public <F> F error(Function0<String> msg, Throwable t, Sync<F> evidence$10) {
        return (F)Logging.error$((Logging)this, msg, (Throwable)t, evidence$10);
    }

    public <F, A> F whenA(boolean cond, Function0<F> f, Monad<F> evidence$1) {
        return (F)CatsUtils.whenA$((CatsUtils)this, (boolean)cond, f, evidence$1);
    }

    public <F> F unit(Sync<F> evidence$2) {
        return (F)CatsUtils.unit$((CatsUtils)this, evidence$2);
    }

    public <F, A> F pure(A a, Sync<F> evidence$3) {
        return (F)CatsUtils.pure$((CatsUtils)this, a, evidence$3);
    }

    public <F, A> F raiseError(Throwable t, Sync<F> evidence$4) {
        return (F)CatsUtils.raiseError$((CatsUtils)this, (Throwable)t, evidence$4);
    }

    public <F, A> F delay(Function0<A> f, Sync<F> evidence$5) {
        return (F)CatsUtils.delay$((CatsUtils)this, f, evidence$5);
    }

    public <F, A> F defer(Function0<F> f, Sync<F> evidence$6) {
        return (F)CatsUtils.defer$((CatsUtils)this, f, evidence$6);
    }

    public <F, A> F liftIO(IO<A> f, Concurrent<F> evidence$7) {
        return (F)CatsUtils.liftIO$((CatsUtils)this, f, evidence$7);
    }

    public <F> F sleep(FiniteDuration duration, Timer<F> evidence$8) {
        return (F)CatsUtils.sleep$((CatsUtils)this, (FiniteDuration)duration, evidence$8);
    }

    public <F, A> F start(F f, Concurrent<F> evidence$9) {
        return (F)CatsUtils.start$((CatsUtils)this, f, evidence$9);
    }

    public <F, A> F fromFuture(Function0<scala.concurrent.Future<A>> f, Concurrent<F> evidence$10) {
        return (F)CatsUtils.fromFuture$((CatsUtils)this, f, evidence$10);
    }

    public <F, A> F fromEither(Either<Throwable, A> e, Concurrent<F> evidence$11) {
        return (F)CatsUtils.fromEither$((CatsUtils)this, e, evidence$11);
    }

    public <F, A> F fromJavaFuture(Function0<Future<A>> future, FiniteDuration pollTime, Concurrent<F> evidence$12) {
        return (F)CatsUtils.fromJavaFuture$((CatsUtils)this, future, (FiniteDuration)pollTime, evidence$12);
    }

    public <F, A> FiniteDuration fromJavaFuture$default$2() {
        return CatsUtils.fromJavaFuture$default$2$((CatsUtils)this);
    }

    public <F, A> F waitFor(Function0<F> f, Function1<A, F> cond, FiniteDuration pollTime, Concurrent<F> evidence$13, Timer<F> evidence$14) {
        return (F)CatsUtils.waitFor$((CatsUtils)this, f, cond, (FiniteDuration)pollTime, evidence$13, evidence$14);
    }

    public <F, A> FiniteDuration waitFor$default$3(Function0<F> f) {
        return CatsUtils.waitFor$default$3$((CatsUtils)this, f);
    }

    public <F, T> CatsUtils.IterableSequenceSyntax<F, T> iterableToSequenceSyntax(Iterable<F> l, Parallel<F> evidence$17, Applicative<F> evidence$18) {
        return CatsUtils.iterableToSequenceSyntax$((CatsUtils)this, l, evidence$17, evidence$18);
    }

    public <F, T> F take(MVar<F, T> mvar, Option<FiniteDuration> timeout, FiniteDuration pollTime, Concurrent<F> evidence$19, Timer<F> evidence$20) {
        return (F)CatsUtils.take$((CatsUtils)this, mvar, timeout, (FiniteDuration)pollTime, evidence$19, evidence$20);
    }

    public <F, T> FiniteDuration take$default$3() {
        return CatsUtils.take$default$3$((CatsUtils)this);
    }

    public <F, A> F guarantee(F fa, F finalizer, Bracket<F, Throwable> bracket) {
        return (F)CatsUtils.guarantee$((CatsUtils)this, fa, finalizer, bracket);
    }

    private Logger logger$lzycompute() {
        Endpoint$ endpoint$ = this;
        synchronized (endpoint$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public CatsUtils$IterableSequenceSyntax$ IterableSequenceSyntax() {
        if (IterableSequenceSyntax$module == null) {
            this.IterableSequenceSyntax$lzycompute$1();
        }
        return IterableSequenceSyntax$module;
    }

    public Either<IllegalArgumentException, Endpoint> apply(Uri uri) {
        return implicits$.MODULE$.catsSyntaxEq((Object)uri.schemeOption(), (Eq)implicits$.MODULE$.catsKernelStdOrderForOption(implicits$.MODULE$.catsKernelStdOrderForString())).$eq$eq$eq((Object)new Some((Object)"pulsar")) ? package$.MODULE$.Right().apply((Object)new PulsarEndpoint(uri)) : (implicits$.MODULE$.catsSyntaxEq((Object)uri.schemeOption(), (Eq)implicits$.MODULE$.catsKernelStdOrderForOption(implicits$.MODULE$.catsKernelStdOrderForString())).$eq$eq$eq((Object)new Some((Object)"tibrv")) ? package$.MODULE$.Right().apply((Object)new TibrvEndpoint(uri)) : (implicits$.MODULE$.catsSyntaxEq((Object)uri.schemeOption(), (Eq)implicits$.MODULE$.catsKernelStdOrderForOption(implicits$.MODULE$.catsKernelStdOrderForString())).$eq$eq$eq((Object)new Some((Object)"activemq")) ? package$.MODULE$.Right().apply((Object)new ActiveMQEndpoint(uri)) : package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(26).append("Not a valid endpoint URI: ").append(uri).toString()))));
    }

    public <F, M> F destinationClient(Endpoint destination, String actualDestination, Concurrent<F> evidence$1, Timer<F> evidence$2, Marshaller<M> evidence$3) {
        Object f;
        Endpoint endpoint = destination;
        if (endpoint instanceof TibrvEndpoint) {
            TibrvEndpoint tibrvEndpoint = (TibrvEndpoint)endpoint;
            f = tibrvEndpoint.withTibrvContext((Function1 & Serializable)tibrvContext -> TibrvServiceConfiguration$.MODULE$.destination(actualDestination, TibrvServiceConfiguration$.MODULE$.destination$default$2(), evidence$3).client(evidence$1, evidence$2, tibrvContext));
        } else if (endpoint instanceof PulsarEndpoint) {
            PulsarEndpoint pulsarEndpoint = (PulsarEndpoint)endpoint;
            f = pulsarEndpoint.withPulsarContext((Function1 & Serializable)pulsarContext -> PulsarServiceConfiguration$.MODULE$.destination(actualDestination, PulsarServiceConfiguration$.MODULE$.destination$default$2(), PulsarServiceConfiguration$.MODULE$.destination$default$3(), evidence$3).client(evidence$1, evidence$2, pulsarContext));
        } else if (endpoint instanceof ActiveMQEndpoint) {
            ActiveMQEndpoint activeMQEndpoint = (ActiveMQEndpoint)endpoint;
            f = activeMQEndpoint.withJMSSession((Function1 & Serializable)session -> JMSServiceConfiguration$.MODULE$.destination((Destination)session.createQueue(actualDestination), evidence$3).client(evidence$1, evidence$2, session));
        } else {
            f = this.raiseError(new IllegalStateException(new StringBuilder(14).append(destination).append(" not supported").toString()), (Sync<F>)evidence$1);
        }
        return f;
    }

    public <F, M> F destinationClient(Endpoint destination, Concurrent<F> evidence$4, Timer<F> evidence$5, Marshaller<M> evidence$6) {
        return this.destinationClient(destination, destination.destinationName(), evidence$4, evidence$5, evidence$6);
    }

    public Some<SubscriptionInitialPosition> defaultSubscriptionInitialPosition() {
        return defaultSubscriptionInitialPosition;
    }

    public Some<Instant> defaultSubscriptionInitialPublishTime() {
        return new Some((Object)Instant.now().minusSeconds(60L));
    }

    public <F, M> F handlerService(Endpoint source, MessageHandler<F, M> messageHandler, Concurrent<F> evidence$7, Timer<F> evidence$8, Marshaller<M> evidence$9, Unmarshaller<M> evidence$10, ContextShift<IO> ioContextShift) {
        Object f;
        Endpoint endpoint = source;
        if (endpoint instanceof PulsarEndpoint) {
            PulsarEndpoint pulsarEndpoint = (PulsarEndpoint)endpoint;
            f = pulsarEndpoint.withPulsarContext((Function1 & Serializable)pulsarContext -> PulsarServiceConfiguration$.MODULE$.handler((Either)package$.MODULE$.Right().apply((Object)pulsarEndpoint.topicPattern()), (Option)new Some((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()), pulsarEndpoint.subscriptionInitialPosition().orElse((Function0 & Serializable)() -> MODULE$.defaultSubscriptionInitialPosition()), pulsarEndpoint.subscriptionInitialPublishTime().orElse((Function0 & Serializable)() -> MODULE$.defaultSubscriptionInitialPublishTime()), (String)pulsarEndpoint.subscriptionName().getOrElse((Function0 & Serializable)() -> new StringBuilder(13).append("subscription-").append(UUID.randomUUID()).toString()), (Function1 & Serializable)x$1 -> (ConsumerBuilder)Predef$.MODULE$.identity(x$1), evidence$9, evidence$10).service(messageHandler, evidence$7, evidence$8, pulsarContext));
        } else if (endpoint instanceof TibrvEndpoint) {
            TibrvEndpoint tibrvEndpoint = (TibrvEndpoint)endpoint;
            f = tibrvEndpoint.withTibrvContext((Function1 & Serializable)tibrvContext -> TibrvServiceConfiguration$.MODULE$.handler(tibrvEndpoint.subjects(), evidence$9, evidence$10).service(messageHandler, evidence$7, evidence$8, tibrvContext, (Concurrent)IO$.MODULE$.ioConcurrentEffect(ioContextShift)));
        } else if (endpoint instanceof ActiveMQEndpoint) {
            ActiveMQEndpoint activeMQEndpoint = (ActiveMQEndpoint)endpoint;
            f = activeMQEndpoint.withJMSSession((Function1 & Serializable)session -> JMSServiceConfiguration$.MODULE$.handler("", (Destination)activeMQEndpoint.destination(), evidence$9, evidence$10).service(messageHandler, evidence$7, session));
        } else {
            f = this.raiseError(new IllegalStateException(new StringBuilder(14).append(source).append(" not supported").toString()), (Sync<F>)evidence$7);
        }
        return f;
    }

    private final void IterableSequenceSyntax$lzycompute$1() {
        Endpoint$ endpoint$ = this;
        synchronized (endpoint$) {
            if (IterableSequenceSyntax$module == null) {
                IterableSequenceSyntax$module = new CatsUtils$IterableSequenceSyntax$((CatsUtils)this);
            }
        }
    }

    private Endpoint$() {
    }
}

