/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.parser;

import io.joern.c2cpg.Config;
import io.joern.c2cpg.astcreation.CGlobal;
import io.joern.c2cpg.parser.CdtParser$;
import io.joern.c2cpg.parser.CdtParser$HeaderFileParserLanguage$;
import io.joern.c2cpg.parser.CdtParser$ParseResult$;
import io.joern.c2cpg.parser.CustomFileContentProvider;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.joern.c2cpg.parser.JSONCompilationDatabaseParser;
import io.joern.c2cpg.parser.ParseProblemsLogger;
import io.joern.c2cpg.parser.ParserConfig;
import io.joern.c2cpg.parser.ParserConfig$;
import io.joern.c2cpg.parser.PreprocessorStatementsLogger;
import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import java.nio.file.Path;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public class CdtParser
implements ParseProblemsLogger,
PreprocessorStatementsLogger {
    private Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    private Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    private final Config config;
    private final HeaderFileFinder headerFileFinder;
    private final CGlobal global;
    private final ParserConfig parserConfig;
    private final DefaultLogService log;
    private int opts;

    public static Seq<Tuple2<Path, ILanguage>> languageMappingForSourceFile(Path path, CGlobal cGlobal, Config config) {
        return CdtParser$.MODULE$.languageMappingForSourceFile(path, cGlobal, config);
    }

    public CdtParser(Config config, HeaderFileFinder headerFileFinder, Option<JSONCompilationDatabaseParser.CompilationDatabase> compilationDatabase, CGlobal global) {
        this.config = config;
        this.headerFileFinder = headerFileFinder;
        this.global = global;
        ParseProblemsLogger.$init$(this);
        PreprocessorStatementsLogger.$init$(this);
        this.parserConfig = ParserConfig$.MODULE$.fromConfig(config, compilationDatabase);
        this.log = new DefaultLogService();
        this.opts = 20;
        if (config.skipFunctionBodies()) {
            this.opts |= 1;
        }
        if (config.compilationDatabaseFilename().isEmpty() && config.defines().isEmpty()) {
            this.opts |= 0x20;
        }
        Statics.releaseFence();
    }

    @Override
    public Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger() {
        return this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$ParseProblemsLogger$_setter_$io$joern$c2cpg$parser$ParseProblemsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger = x$0;
    }

    @Override
    public Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger() {
        return this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$PreprocessorStatementsLogger$_setter_$io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger = x$0;
    }

    public Iterable<IASTPreprocessorStatement> preprocessorStatements(Path file, ILanguage language) {
        return (Iterable)this.parse(file, language).map((Function1 & Serializable)t -> this.preprocessorStatements((IASTTranslationUnit)t)).getOrElse(CdtParser::preprocessorStatements$$anonfun$2);
    }

    public Option<IASTTranslationUnit> parse(Path file, ILanguage language) {
        ParseResult parseResult = this.parseInternal(file, language);
        if (parseResult != null) {
            ParseResult parseResult2 = CdtParser$ParseResult$.MODULE$.unapply(parseResult);
            Option<IASTTranslationUnit> option = parseResult2._1();
            Option<String> option2 = parseResult2._2();
            Option<Throwable> option3 = parseResult2._3();
            if (option instanceof Some) {
                Some translationUnit = (Some)option;
                if (option2 instanceof Some) {
                    String relativeFilePath = (String)((Some)option2).value();
                    CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.info("Parsed '" + relativeFilePath + "'");
                    return translationUnit;
                }
            }
            Option<String> maybeRelativePath = option2;
            Option<Throwable> maybeThrowable = option3;
            String relativePath = (String)maybeRelativePath.getOrElse(() -> CdtParser.$anonfun$1(file));
            String throwableText = (String)maybeThrowable.map((Function1 & Serializable)exception -> this.extractParseException((Throwable)exception)).getOrElse(CdtParser::$anonfun$3);
            CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.warn("Failed to parse '" + relativePath + "': " + throwableText);
            return None$.MODULE$;
        }
        throw new MatchError((Object)parseResult);
    }

    private ParseResult parseInternal(Path file, ILanguage language) {
        ParseResult parseResult;
        try {
            String relativeFilePath = SourceFiles$.MODULE$.toRelativePath(file.toString(), this.config.inputPath());
            CustomFileContentProvider fileContentProvider = new CustomFileContentProvider(this.headerFileFinder, file.toString(), this.global);
            ScannerInfo scInfo = this.createScannerInfo(file);
            FileContent fContent = CdtParser$.MODULE$.io$joern$c2cpg$parser$CdtParser$$$readFileAsFileContent(file, CdtParser$.MODULE$.io$joern$c2cpg$parser$CdtParser$$$readFileAsFileContent$default$2());
            IASTTranslationUnit translationUnit = language.getASTTranslationUnit(fContent, (IScannerInfo)scInfo, (IncludeFileContentProvider)fileContentProvider, null, this.opts, (IParserLogService)this.log);
            if (this.config.logProblems()) {
                this.logProblems(translationUnit);
            }
            if (this.config.logPreprocessor()) {
                this.logPreprocessorStatements(translationUnit);
            }
            parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)Option$.MODULE$.apply((Object)translationUnit), (Option<String>)Some$.MODULE$.apply((Object)relativeFilePath), CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3());
        }
        catch (UnsupportedClassVersionError u) {
            CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.error("c2cpg requires at least JRE-17 to run. Please check your Java Runtime Environment!", (Throwable)u);
            System.exit(1);
            None$ none$ = None$.MODULE$;
            Option option = Option$.MODULE$.apply((Object)u);
            Option<String> option2 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
            parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, option2, (Option<Throwable>)option);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                None$ none$ = None$.MODULE$;
                Option option3 = Option$.MODULE$.apply((Object)e);
                Option<String> option4 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, option4, (Option<Throwable>)option3);
            }
            throw throwable;
        }
        return parseResult;
    }

    private ScannerInfo createScannerInfo(Path file) {
        LinkedHashSet<Path> additionalIncludes = FileDefaults$.MODULE$.hasCppFileExtension(file.toString()) ? this.parserConfig.systemIncludePathsCPP() : this.parserConfig.systemIncludePathsC();
        scala.collection.immutable.Map fileSpecificDefines = (scala.collection.immutable.Map)this.parserConfig.definedSymbolsPerFile().getOrElse((Object)file.toString(), CdtParser::$anonfun$4);
        LinkedHashSet fileSpecificIncludes = (LinkedHashSet)this.parserConfig.includesPerFile().getOrElse((Object)file.toString(), CdtParser::$anonfun$5);
        Object object = Predef$.MODULE$.refArrayOps((Object[])fileSpecificIncludes.toArray(ClassTag$.MODULE$.apply(String.class)));
        return new ScannerInfo(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.parserConfig.definedSymbols().$plus$plus((IterableOnce)fileSpecificDefines)).asJava(), (String[])ArrayOps$.MODULE$.$plus$plus$extension(object, ((IterableOnceOps)((StrictOptimizedIterableOps)this.parserConfig.userIncludePaths().$plus$plus(additionalIncludes)).map((Function1 & Serializable)_$1 -> _$1.toString())).toArray(ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class)));
    }

    public Option<IASTTranslationUnit> parse(String code, Path inFile) {
        Try try_ = Try$.MODULE$.apply(() -> this.parse$$anonfun$1(code, inFile));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            String relativePath = SourceFiles$.MODULE$.toRelativePath(inFile.toString(), this.config.inputPath());
            CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.warn("Failed to parse '" + code + "' in file '" + relativePath + "': " + this.extractParseException(exception));
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            IASTTranslationUnit translationUnit = (IASTTranslationUnit)((Success)try_).value();
            return Option$.MODULE$.apply((Object)translationUnit);
        }
        throw new MatchError((Object)try_);
    }

    private IASTTranslationUnit parseInternal(String code, Path inFile) {
        FileContent fileContent = FileContent.create((String)inFile.toString(), (boolean)true, (char[])code.toCharArray());
        CustomFileContentProvider fileContentProvider = new CustomFileContentProvider(this.headerFileFinder, inFile.toString(), this.global);
        ILanguage lang = CdtParser$.MODULE$.io$joern$c2cpg$parser$CdtParser$$$createParseLanguage(inFile, code, this.config);
        ScannerInfo scannerInfo = this.createScannerInfo(inFile);
        IASTTranslationUnit translationUnit = lang.getASTTranslationUnit(fileContent, (IScannerInfo)scannerInfo, (IncludeFileContentProvider)fileContentProvider, null, this.opts, (IParserLogService)this.log);
        if (this.config.logProblems()) {
            this.logProblems(translationUnit);
        }
        if (this.config.logPreprocessor()) {
            this.logPreprocessorStatements(translationUnit);
        }
        return translationUnit;
    }

    private static final Iterable preprocessorStatements$$anonfun$2() {
        return (Iterable)package$.MODULE$.Iterable().empty();
    }

    private static final String $anonfun$1(Path file$1) {
        return file$1.toString();
    }

    private static final String $anonfun$3() {
        return "Unknown parse error!";
    }

    private static final scala.collection.immutable.Map $anonfun$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final LinkedHashSet $anonfun$5() {
        return LinkedHashSet$.MODULE$.empty();
    }

    private final IASTTranslationUnit parse$$anonfun$1(String code$1, Path inFile$1) {
        return this.parseInternal(code$1, inFile$1);
    }

    public static abstract class HeaderFileParserLanguage
    implements Product,
    Enum {
        public static HeaderFileParserLanguage fromOrdinal(int n) {
            return CdtParser$HeaderFileParserLanguage$.MODULE$.fromOrdinal(n);
        }

        public static HeaderFileParserLanguage valueOf(String string) {
            return CdtParser$HeaderFileParserLanguage$.MODULE$.valueOf(string);
        }

        public static HeaderFileParserLanguage[] values() {
            return CdtParser$HeaderFileParserLanguage$.MODULE$.values();
        }
    }

    public static class ParseResult
    implements Product,
    Serializable {
        private final Option<IASTTranslationUnit> translationUnit;
        private final Option<String> relativeFilePath;
        private final Option<Throwable> failure;

        public static ParseResult apply(Option<IASTTranslationUnit> option, Option<String> option2, Option<Throwable> option3) {
            return CdtParser$ParseResult$.MODULE$.apply(option, option2, option3);
        }

        public static ParseResult fromProduct(Product product) {
            return CdtParser$ParseResult$.MODULE$.fromProduct(product);
        }

        public static ParseResult unapply(ParseResult parseResult) {
            return CdtParser$ParseResult$.MODULE$.unapply(parseResult);
        }

        public static Option<String> $lessinit$greater$default$2() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Throwable> $lessinit$greater$default$3() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
        }

        public ParseResult(Option<IASTTranslationUnit> translationUnit, Option<String> relativeFilePath, Option<Throwable> failure) {
            this.translationUnit = translationUnit;
            this.relativeFilePath = relativeFilePath;
            this.failure = failure;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseResult)) return false;
            ParseResult parseResult = (ParseResult)object;
            Option<IASTTranslationUnit> option = this.translationUnit();
            Option<IASTTranslationUnit> option2 = parseResult.translationUnit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.relativeFilePath();
            Option<String> option4 = parseResult.relativeFilePath();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Throwable> option5 = this.failure();
            Option<Throwable> option6 = parseResult.failure();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            if (!parseResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ParseResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "translationUnit";
                }
                case 1: {
                    return "relativeFilePath";
                }
                case 2: {
                    return "failure";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<IASTTranslationUnit> translationUnit() {
            return this.translationUnit;
        }

        public Option<String> relativeFilePath() {
            return this.relativeFilePath;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        public ParseResult copy(Option<IASTTranslationUnit> translationUnit, Option<String> relativeFilePath, Option<Throwable> failure) {
            return new ParseResult(translationUnit, relativeFilePath, failure);
        }

        public Option<IASTTranslationUnit> copy$default$1() {
            return this.translationUnit();
        }

        public Option<String> copy$default$2() {
            return this.relativeFilePath();
        }

        public Option<Throwable> copy$default$3() {
            return this.failure();
        }

        public Option<IASTTranslationUnit> _1() {
            return this.translationUnit();
        }

        public Option<String> _2() {
            return this.relativeFilePath();
        }

        public Option<Throwable> _3() {
            return this.failure();
        }
    }
}

