/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.parser;

import io.joern.c2cpg.astcreation.CGlobal;
import io.joern.c2cpg.parser.CdtParser;
import io.joern.c2cpg.parser.CdtParser$HeaderFileParserLanguage$;
import io.joern.c2cpg.parser.CustomFileContentProvider$;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Paths;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;

public class CustomFileContentProvider
extends InternalFileContentProvider {
    private final HeaderFileFinder headerFileFinder;
    private final String sourceFile;
    private final CGlobal global;
    private final Logger logger;

    public CustomFileContentProvider(HeaderFileFinder headerFileFinder, String sourceFile, CGlobal global) {
        this.headerFileFinder = headerFileFinder;
        this.sourceFile = sourceFile;
        this.global = global;
        this.logger = LoggerFactory.getLogger(CustomFileContentProvider.class);
    }

    public InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
        return this.loadContent(path);
    }

    public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
        return this.loadContent(astPath);
    }

    private InternalFileContent loadContent(String path) {
        Option<String> maybeFullPath = !this.getInclusionExists(path) ? this.headerFileFinder.find(path) : Option$.MODULE$.apply((Object)path);
        return (InternalFileContent)maybeFullPath.map((Function1 & Serializable)foundPath -> {
            this.updateHeaderFileParserLanguage((String)foundPath);
            char[] content = this.contentFromCache((String)foundPath);
            return (InternalFileContent)FileContent.create((String)path, (boolean)false, (char[])content);
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private char[] contentFromCache(String foundPath) {
        return CustomFileContentProvider$.io$joern$c2cpg$parser$CustomFileContentProvider$$$headerContentCache.computeIfAbsent(foundPath, _$1 -> {
            this.logger.debug("Loading header file '" + foundPath + "'");
            return (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(IOUtils$.MODULE$.readLinesInFile(Paths.get(foundPath, new String[0])).mkString("\n")), ClassTag$.MODULE$.apply(Character.TYPE));
        });
    }

    private void updateHeaderFileParserLanguage(String foundPath) {
        if (FileDefaults$.MODULE$.hasCHeaderFileExtension(foundPath)) {
            CdtParser.HeaderFileParserLanguage currentLanguage = FileDefaults$.MODULE$.hasCFileExtension(this.sourceFile) ? CdtParser$HeaderFileParserLanguage$.C : CdtParser$HeaderFileParserLanguage$.Cpp;
            this.global.headerIncludes().compute(foundPath, (_$2, previousLanguage) -> {
                if (previousLanguage == null) {
                    return currentLanguage;
                }
                CdtParser.HeaderFileParserLanguage headerFileParserLanguage = previousLanguage;
                CdtParser.HeaderFileParserLanguage headerFileParserLanguage2 = currentLanguage;
                if (headerFileParserLanguage == null ? headerFileParserLanguage2 != null : !headerFileParserLanguage.equals(headerFileParserLanguage2)) {
                    return CdtParser$HeaderFileParserLanguage$.Both;
                }
                return previousLanguage;
            });
            return;
        }
    }
}

