/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.passes;

import flatgraph.DiffGraphBuilder;
import io.joern.c2cpg.C2Cpg$;
import io.joern.c2cpg.Config;
import io.joern.c2cpg.astcreation.AstCreator;
import io.joern.c2cpg.astcreation.CGlobal;
import io.joern.c2cpg.parser.CdtParser;
import io.joern.c2cpg.parser.CdtParser$;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.joern.c2cpg.parser.JSONCompilationDatabaseParser;
import io.joern.c2cpg.parser.JSONCompilationDatabaseParser$;
import io.joern.c2cpg.passes.AstCreationPass$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.utils.Report;
import io.joern.x2cpg.utils.TimeUtils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ForkJoinParallelCpgPass<Tuple2<Path, ILanguage>> {
    private final List<String> preprocessedFiles;
    private final Set<String> fileExtensions;
    private final Config config;
    private final CGlobal global;
    private final Report report;
    private final Option<JSONCompilationDatabaseParser.CompilationDatabase> compilationDatabase;
    private final Logger logger;
    private final HeaderFileFinder headerFileFinder;
    private final CdtParser parser;

    public static Report $lessinit$greater$default$6() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$6();
    }

    public AstCreationPass(Cpg cpg, List<String> preprocessedFiles, Set<String> fileExtensions, Config config, CGlobal global, Report report) {
        this.preprocessedFiles = preprocessedFiles;
        this.fileExtensions = fileExtensions;
        this.config = config;
        this.global = global;
        this.report = report;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2());
        this.compilationDatabase = config.compilationDatabaseFilename().flatMap((Function1 & Serializable)compileCommandsJson -> JSONCompilationDatabaseParser$.MODULE$.parse((String)compileCommandsJson));
        this.logger = LoggerFactory.getLogger(AstCreationPass.class);
        this.headerFileFinder = new HeaderFileFinder(config);
        this.parser = new CdtParser(config, this.headerFileFinder, this.compilationDatabase, global);
    }

    public Tuple2<Path, ILanguage>[] generateParts() {
        Object[] sourceFiles = this.config.compilationDatabaseFilename().isEmpty() ? this.sourceFilesFromDirectory() : this.sourceFilesFromCompilationDatabase((String)this.config.compilationDatabaseFilename().get());
        Object object = Predef$.MODULE$.refArrayOps(sourceFiles);
        return (Tuple2[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)file -> {
            Path path = Paths.get(file, new String[0]).toAbsolutePath();
            return CdtParser$.MODULE$.languageMappingForSourceFile(path, this.global, this.config);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private String[] sourceFilesFromDirectory() {
        String string = this.config.inputPath();
        Option option = Option$.MODULE$.apply(C2Cpg$.MODULE$.DefaultIgnoredFolders());
        Option option2 = Option$.MODULE$.apply((Object)this.config.ignoredFilesRegex());
        Option option3 = Option$.MODULE$.apply((Object)this.config.ignoredFiles());
        Object[] allSourceFiles = (String[])SourceFiles$.MODULE$.determine(string, this.fileExtensions, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, this.fileExtensions, option, option2, option3)).toArray(ClassTag$.MODULE$.apply(String.class));
        if (this.config.withPreprocessedFiles()) {
            Object object = Predef$.MODULE$.refArrayOps(allSourceFiles);
            return (String[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)x$1 -> {
                String string = x$1;
                String f = string;
                if (!FileDefaults$.MODULE$.hasPreprocessedFileExtension(f)) {
                    String fAsPreprocessedFile = f.substring(0, f.lastIndexOf(".")) + FileDefaults$.MODULE$.PreprocessedExt();
                    return !this.preprocessedFiles.exists((Function1 & Serializable)sourceFile -> {
                        String string = f;
                        String string2 = sourceFile;
                        if (string == null) {
                            if (string2 == null) return false;
                        } else if (string.equals(string2)) return false;
                        String string3 = sourceFile;
                        String string4 = fAsPreprocessedFile;
                        if (string3 != null) {
                            if (!string3.equals(string4)) return false;
                            return true;
                        }
                        if (string4 == null) return true;
                        return false;
                    });
                }
                return true;
            });
        }
        return allSourceFiles;
    }

    private String[] sourceFilesFromCompilationDatabase(String compilationDatabaseFile) {
        Option<JSONCompilationDatabaseParser.CompilationDatabase> option = this.compilationDatabase;
        if (option instanceof Some) {
            JSONCompilationDatabaseParser.CompilationDatabase db = (JSONCompilationDatabaseParser.CompilationDatabase)((Some)option).value();
            List files = ((IterableOnceOps)db.commands().map((Function1 & Serializable)_$1 -> _$1.compiledFile())).toList();
            List filteredFiles = files.filter((Function1 & Serializable)f -> this.fileExtensions.exists((Function1 & Serializable)_$2 -> StringUtils.endsWithIgnoreCase((CharSequence)f, (CharSequence)_$2)));
            return (String[])SourceFiles$.MODULE$.filterFiles(filteredFiles, this.config.inputPath(), Option$.MODULE$.apply(C2Cpg$.MODULE$.DefaultIgnoredFolders()), Option$.MODULE$.apply((Object)this.config.ignoredFilesRegex()), Option$.MODULE$.apply((Object)this.config.ignoredFiles())).toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (None$.MODULE$.equals(option)) {
            this.logger.warn("'" + compilationDatabaseFile + "' contains no source files. CPG will be empty.");
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        throw new MatchError(option);
    }

    public void runOnPart(DiffGraphBuilder diffGraph, Tuple2<Path, ILanguage> fileAndLanguage) {
        Tuple2<Path, ILanguage> tuple2 = fileAndLanguage;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Path path = (Path)tuple2._1();
        ILanguage language = (ILanguage)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)path, (Object)language);
        Path path2 = (Path)tuple22._1();
        ILanguage language2 = (ILanguage)tuple22._2();
        String relPath = SourceFiles$.MODULE$.toRelativePath(path2.toString(), this.config.inputPath());
        Tuple2 tuple23 = TimeUtils$.MODULE$.time(() -> this.$anonfun$3(path2, language2, relPath, diffGraph));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        boolean gotCpg = tuple23._1$mcZ$sp();
        long duration = tuple23._2$mcJ$sp();
        Tuple2.mcZJ.sp sp2 = new Tuple2.mcZJ.sp(gotCpg, duration);
        boolean gotCpg2 = sp2._1$mcZ$sp();
        long duration2 = sp2._2$mcJ$sp();
        this.report.updateReport(relPath, gotCpg2, duration2);
    }

    private final void $anonfun$3$$anonfun$1(String relPath$2, IASTTranslationUnit translationUnit$1, DiffGraphBuilder diffGraph$2) {
        DiffGraphBuilder localDiff = new AstCreator(relPath$2, this.global, this.config, translationUnit$1, this.headerFileFinder).createAst();
        diffGraph$2.absorb(localDiff);
    }

    private final boolean $anonfun$3(Path path$1, ILanguage language$1, String relPath$1, DiffGraphBuilder diffGraph$1) {
        Option<IASTTranslationUnit> parseResult = this.parser.parse(path$1, language$1);
        Option<IASTTranslationUnit> option = parseResult;
        if (option instanceof Some) {
            IASTTranslationUnit translationUnit = (IASTTranslationUnit)((Some)option).value();
            int fileLOC = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(translationUnit.getRawSignature())).size();
            this.report.addReportInfo(relPath$1, fileLOC, true, this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.$anonfun$3$$anonfun$1(relPath$1, translationUnit, diffGraph$1);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.warn("Failed to generate a CPG for: '" + relPath$1 + "'", exception);
                return false;
            }
            if (try_ instanceof Success) {
                return true;
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option)) {
            this.report.addReportInfo(relPath$1, -1, this.report.addReportInfo$default$3(), this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
            return false;
        }
        throw new MatchError(option);
    }
}

