/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.passes;

import flatgraph.DiffGraphBuilder;
import flatgraph.GNode;
import flatgraph.traversal.GenericSteps$;
import io.joern.c2cpg.astcreation.Defines$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.accessors.Accessors;
import io.shiftleft.codepropertygraph.generated.neighboraccessors.AccessNeighborsForBinding$;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Binding;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.NamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyMethodFullName$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyName$;
import io.shiftleft.passes.CpgPass;
import io.shiftleft.passes.CpgPass$;
import io.shiftleft.semanticcpg.language.nodemethods.StoredNodeMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.language.types.propertyaccessors.ModifierAccessors$;
import io.shiftleft.semanticcpg.language.types.structure.NamespaceTraversal$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;

public class FullNameUniquenessPass
extends CpgPass {
    private final Cpg cpg;
    private final Logger logger;

    public FullNameUniquenessPass(Cpg cpg) {
        this.cpg = cpg;
        super(cpg, CpgPass$.MODULE$.$lessinit$greater$default$2());
        this.logger = LoggerFactory.getLogger(FullNameUniquenessPass.class);
    }

    public void run(DiffGraphBuilder dstGraph) {
        this.handleMethods(dstGraph);
        this.handleTypeDecls(dstGraph);
        this.handleNamespaceBlocks(dstGraph);
    }

    private void handleMethods(DiffGraphBuilder dstGraph) {
        Iterator iterator = package$.MODULE$.accessPropertyNameTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).method());
        Seq methodFullNameMap = this.generateStableFullNameMapping(TraversalPropertyName$.MODULE$.nameNot$extension(iterator, NamespaceTraversal$.MODULE$.globalNamespaceName()));
        methodFullNameMap.foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String fullName = (String)tuple2._1();
                List methods = (List)tuple2._2();
                LazyRef lazyRef = new LazyRef();
                LazyRef lazyRef2 = new LazyRef();
                this.logDuplicates(methods, fullName);
                List sortedMethods = this.sortNodesByLocation(methods);
                ((List)((StrictOptimizedIterableOps)sortedMethods.tail()).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String string;
                        boolean isCFunction;
                        Method method = (Method)tuple2._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        String suffix = Defines$.MODULE$.DuplicateSuffix() + index;
                        String signature = Accessors.AccessPropertySignature$.MODULE$.signature$extension(package$.MODULE$.accessPropertySignature((StoredNode)method));
                        boolean bl = isCFunction = !fullName.endsWith(":" + signature);
                        if (isCFunction) {
                            string = fullName + suffix;
                        } else {
                            String fullNameWithoutSignature = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fullName), ":" + signature);
                            string = fullNameWithoutSignature + suffix + ":" + signature;
                        }
                        String newFullName = string;
                        dstGraph.setNodeProperty((GNode)method, Method.PropertyNames$.MODULE$.FullName(), (Object)newFullName);
                        this.bindingsAffected$1(lazyRef2, fullName).filter((Function1 & Serializable)_$3 -> AccessNeighborsForBinding$.MODULE$.refOut$extension(package$.MODULE$.accessNeighborsForBinding(_$3)).contains((Object)method)).foreach((Function1 & Serializable)binding -> {
                            dstGraph.setNodeProperty((GNode)binding, Binding.PropertyNames$.MODULE$.Name(), (Object)(Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)binding)) + suffix));
                            return dstGraph.setNodeProperty((GNode)binding, Binding.PropertyNames$.MODULE$.MethodFullName(), (Object)newFullName);
                        });
                        Iterator iterator = package$.MODULE$.singleToModifierAccessorsMethod(method);
                        if (ModifierAccessors$.MODULE$.isStatic$extension(iterator).nonEmpty()) {
                            List callCandidates = this.callsAffected$1(lazyRef, fullName, sortedMethods).filter((Function1 & Serializable)_$4 -> StoredNodeMethods$.MODULE$.file$extension(package$.MODULE$.toExtendedStoredNode((StoredNode)_$4)).exists((Function1 & Serializable)_$5 -> {
                                String string = Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)_$5));
                                String string2 = Accessors.AccessPropertyFilename$.MODULE$.filename$extension(package$.MODULE$.accessPropertyFilename((StoredNode)method));
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }));
                            callCandidates.foreach((Function1 & Serializable)call -> {
                                dstGraph.setNodeProperty((GNode)call, Call.PropertyNames$.MODULE$.Name(), (Object)(Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)call)) + suffix));
                                return dstGraph.setNodeProperty((GNode)call, Call.PropertyNames$.MODULE$.MethodFullName(), (Object)newFullName);
                            });
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private <T extends AstNode> Seq<Tuple2<String, List<T>>> generateStableFullNameMapping(Iterator<T> nodes) {
        Iterator iterator = package$.MODULE$.iterableToGenericSteps(nodes);
        Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)GenericSteps$.MODULE$.groupBy$extension(iterator, (Function1 & Serializable)_$6 -> Accessors.AccessPropertyFullName$.MODULE$.fullName$extension(package$.MODULE$.accessPropertyFullName((StoredNode)_$6))).filter((Function1 & Serializable)_$7 -> ((SeqOps)_$7._2()).size() > 1));
        return GenericSteps$.MODULE$.sortBy$extension(iterator2, (Function1 & Serializable)_$8 -> (String)_$8._1(), (Ordering)Ordering.String$.MODULE$);
    }

    private <T extends AstNode> List<T> sortNodesByLocation(List<T> nodes) {
        return (List)nodes.sortBy((Function1 & Serializable)node -> {
            String fileName = Accessors.AccessPropertyFilename$.MODULE$.filename$extension(package$.MODULE$.accessPropertyFilename((StoredNode)node));
            int lineNr = BoxesRunTime.unboxToInt((Object)Accessors.AccessPropertyLineNumber$.MODULE$.lineNumber$extension(package$.MODULE$.accessPropertyLineNumber((StoredNode)node)).getOrElse(FullNameUniquenessPass::$anonfun$2));
            int columnNr = BoxesRunTime.unboxToInt((Object)Accessors.AccessPropertyColumnNumber$.MODULE$.columnNumber$extension(package$.MODULE$.accessPropertyColumnNumber((StoredNode)node)).getOrElse(FullNameUniquenessPass::$anonfun$3));
            return Tuple3$.MODULE$.apply((Object)fileName, (Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)columnNr));
        }, Ordering$.MODULE$.Tuple3((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
    }

    private <T extends AstNode> void logDuplicates(List<T> nodes, String fullName) {
        if (this.logger.isDebugEnabled()) {
            String fromFiles = nodes.map((Function1 & Serializable)_$9 -> Accessors.AccessPropertyFilename$.MODULE$.filename$extension(package$.MODULE$.accessPropertyFilename((StoredNode)_$9))).mkString("[", ", ", "]");
            String nodeLabel = (String)nodes.headOption().map((Function1 & Serializable)_$10 -> ((GNode)_$10).label()).getOrElse(FullNameUniquenessPass::$anonfun$6);
            this.logger.debug("Found " + nodes.size() + " duplicate " + nodeLabel + " fullNames for '" + fullName + "' in: " + fromFiles);
            return;
        }
    }

    private void handleTypeDecls(DiffGraphBuilder dstGraph) {
        Iterator iterator = package$.MODULE$.accessPropertyNameTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).typeDecl());
        this.handleDuplicateFullNames(TraversalPropertyName$.MODULE$.nameNot$extension(iterator, NamespaceTraversal$.MODULE$.globalNamespaceName()), TypeDecl.PropertyNames$.MODULE$.FullName(), dstGraph);
    }

    private void handleNamespaceBlocks(DiffGraphBuilder dstGraph) {
        Iterator iterator = package$.MODULE$.accessPropertyNameTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).namespaceBlock());
        this.handleDuplicateFullNames(TraversalPropertyName$.MODULE$.nameNot$extension(iterator, NamespaceTraversal$.MODULE$.globalNamespaceName()), NamespaceBlock.PropertyNames$.MODULE$.FullName(), dstGraph);
    }

    private <T extends AstNode> void handleDuplicateFullNames(Iterator<T> nodes, String fullNameProperty, DiffGraphBuilder dstGraph) {
        Seq<Tuple2<String, List<T>>> fullNameMap = this.generateStableFullNameMapping(nodes);
        fullNameMap.foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String fullName = (String)tuple2._1();
                List nodesList = (List)tuple2._2();
                this.logDuplicates(nodesList, fullName);
                List sortedNodes = this.sortNodesByLocation(nodesList);
                ((List)((StrictOptimizedIterableOps)sortedNodes.tail()).zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        AstNode node = (AstNode)tuple2._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        String suffix = Defines$.MODULE$.DuplicateSuffix() + index;
                        String newFullName = Accessors.AccessPropertyFullName$.MODULE$.fullName$extension(package$.MODULE$.accessPropertyFullName((StoredNode)node)) + suffix;
                        return dstGraph.setNodeProperty((GNode)node, fullNameProperty, (Object)newFullName);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final List callsAffected$lzyINIT1$1(LazyRef callsAffected$lzy1$1, String fullName$1, List sortedMethods$1) {
        List list;
        LazyRef lazyRef = callsAffected$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (callsAffected$lzy1$1.initialized()) {
                object = callsAffected$lzy1$1.value();
            } else {
                Iterator iterator = package$.MODULE$.accessPropertyMethodFullNameTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).call());
                Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)TraversalPropertyMethodFullName$.MODULE$.methodFullNameExact$extension(iterator, fullName$1).filterNot((Function1 & Serializable)_$1 -> StoredNodeMethods$.MODULE$.file$extension(package$.MODULE$.toExtendedStoredNode((StoredNode)_$1)).exists((Function1 & Serializable)_$2 -> {
                    String string = Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)_$2));
                    String string2 = Accessors.AccessPropertyFilename$.MODULE$.filename$extension(package$.MODULE$.accessPropertyFilename((StoredNode)sortedMethods$1.head()));
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })));
                object = callsAffected$lzy1$1.initialize((Object)GenericSteps$.MODULE$.l$extension(iterator2));
            }
            list = (List)object;
        }
        return list;
    }

    private final List callsAffected$1(LazyRef callsAffected$lzy1$2, String fullName$2, List sortedMethods$4) {
        return (List)(callsAffected$lzy1$2.initialized() ? callsAffected$lzy1$2.value() : this.callsAffected$lzyINIT1$1(callsAffected$lzy1$2, fullName$2, sortedMethods$4));
    }

    private final List bindingsAffected$lzyINIT1$1(LazyRef bindingsAffected$lzy1$1, String fullName$3) {
        List list;
        LazyRef lazyRef = bindingsAffected$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (bindingsAffected$lzy1$1.initialized()) {
                object = bindingsAffected$lzy1$1.value();
            } else {
                Iterator iterator = package$.MODULE$.accessPropertyMethodFullNameTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).binding());
                Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)TraversalPropertyMethodFullName$.MODULE$.methodFullNameExact$extension(iterator, fullName$3));
                object = bindingsAffected$lzy1$1.initialize((Object)GenericSteps$.MODULE$.l$extension(iterator2));
            }
            list = (List)object;
        }
        return list;
    }

    private final List bindingsAffected$1(LazyRef bindingsAffected$lzy1$2, String fullName$4) {
        return (List)(bindingsAffected$lzy1$2.initialized() ? bindingsAffected$lzy1$2.value() : this.bindingsAffected$lzyINIT1$1(bindingsAffected$lzy1$2, fullName$4));
    }

    private static final int $anonfun$2() {
        return -1;
    }

    private static final int $anonfun$3() {
        return -1;
    }

    private static final String $anonfun$6() {
        return "";
    }
}

