/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.passes;

import io.joern.c2cpg.C2Cpg$;
import io.joern.c2cpg.Config;
import io.joern.c2cpg.astcreation.CGlobal;
import io.joern.c2cpg.parser.CdtParser;
import io.joern.c2cpg.parser.CdtParser$;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.joern.c2cpg.parser.JSONCompilationDatabaseParser;
import io.joern.c2cpg.parser.JSONCompilationDatabaseParser$;
import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.model.ILanguage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.package$;

public class PreprocessorPass {
    private final Config config;
    private final Logger logger;
    private final Option<JSONCompilationDatabaseParser.CompilationDatabase> compilationDatabase;
    private final CGlobal global;
    private final CdtParser parser;

    public PreprocessorPass(Config config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger(PreprocessorPass.class);
        this.compilationDatabase = config.compilationDatabaseFilename().flatMap((Function1 & Serializable)compileCommandsJson -> JSONCompilationDatabaseParser$.MODULE$.parse((String)compileCommandsJson));
        HeaderFileFinder headerFileFinder = new HeaderFileFinder(config);
        this.global = new CGlobal();
        this.parser = new CdtParser(config, headerFileFinder, this.compilationDatabase, this.global);
    }

    public Iterable<String> run() {
        Iterable<String> sourceFiles = this.config.compilationDatabaseFilename().isEmpty() ? this.sourceFilesFromDirectory() : this.sourceFilesFromCompilationDatabase((String)this.config.compilationDatabaseFilename().get());
        return (Iterable)((IterableOps)sourceFiles.flatMap((Function1 & Serializable)file -> {
            Path path = Paths.get(file, new String[0]).toAbsolutePath();
            return CdtParser$.MODULE$.languageMappingForSourceFile(path, this.global, this.config);
        })).flatMap((Function1 & Serializable)fileAndLanguage -> this.runOnPart((Tuple2<Path, ILanguage>)fileAndLanguage));
    }

    private Iterable<String> sourceFilesFromDirectory() {
        String string = this.config.inputPath();
        Set<String> set = FileDefaults$.MODULE$.SourceFileExtensions();
        Option option = Option$.MODULE$.apply(C2Cpg$.MODULE$.DefaultIgnoredFolders());
        Option option2 = Option$.MODULE$.apply((Object)this.config.ignoredFilesRegex());
        Option option3 = Option$.MODULE$.apply((Object)this.config.ignoredFiles());
        return SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3));
    }

    private Iterable<String> sourceFilesFromCompilationDatabase(String compilationDatabaseFile) {
        Option<JSONCompilationDatabaseParser.CompilationDatabase> option = this.compilationDatabase;
        if (option instanceof Some) {
            JSONCompilationDatabaseParser.CompilationDatabase db = (JSONCompilationDatabaseParser.CompilationDatabase)((Some)option).value();
            return SourceFiles$.MODULE$.filterFiles(((IterableOnceOps)db.commands().map((Function1 & Serializable)_$1 -> _$1.compiledFile())).toList(), this.config.inputPath(), Option$.MODULE$.apply(C2Cpg$.MODULE$.DefaultIgnoredFolders()), Option$.MODULE$.apply((Object)this.config.ignoredFilesRegex()), Option$.MODULE$.apply((Object)this.config.ignoredFiles()));
        }
        if (None$.MODULE$.equals(option)) {
            this.logger.warn("'" + compilationDatabaseFile + "' contains no source files. CPG will be empty.");
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
        throw new MatchError(option);
    }

    private Option<String> preprocessorStatement2String(IASTPreprocessorStatement stmt) {
        IASTPreprocessorStatement iASTPreprocessorStatement = stmt;
        if (iASTPreprocessorStatement instanceof IASTPreprocessorIfStatement) {
            IASTPreprocessorIfStatement s = (IASTPreprocessorIfStatement)iASTPreprocessorStatement;
            return Option$.MODULE$.apply((Object)(Predef$.MODULE$.wrapCharArray(s.getCondition()).mkString() + (s.taken() ? "=true" : "")));
        }
        if (iASTPreprocessorStatement instanceof IASTPreprocessorIfdefStatement) {
            IASTPreprocessorIfdefStatement s = (IASTPreprocessorIfdefStatement)iASTPreprocessorStatement;
            return Option$.MODULE$.apply((Object)(Predef$.MODULE$.wrapCharArray(s.getCondition()).mkString() + (s.taken() ? "=true" : "")));
        }
        return None$.MODULE$;
    }

    private Iterable<String> runOnPart(Tuple2<Path, ILanguage> fileAndLanguage) {
        Tuple2<Path, ILanguage> tuple2 = fileAndLanguage;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Path path = (Path)tuple2._1();
        ILanguage language = (ILanguage)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)path, (Object)language);
        Path path2 = (Path)tuple22._1();
        ILanguage language2 = (ILanguage)tuple22._2();
        return ((IterableOnceOps)this.parser.preprocessorStatements(path2, language2).flatMap((Function1 & Serializable)stmt -> this.preprocessorStatement2String((IASTPreprocessorStatement)stmt))).toSet();
    }
}

