/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.utils;

import io.joern.c2cpg.Config;
import io.joern.c2cpg.utils.GccSpecificExternalCommand$;
import io.shiftleft.semanticcpg.utils.ExternalCommand$;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;

public final class IncludeAutoDiscovery$
implements Serializable {
    private static final Logger logger;
    private static final boolean IsWin;
    private static final Seq<String> GccVersionCommand;
    private static final Seq<String> CppIncludeCommand;
    private static final Seq<String> CIncludeCommand;
    private static final Seq<String> VsWhereCommand;
    private static final Seq<String> VcVarsCommand;
    private static final Map<String, String> LanguageSetting;
    private static Option<Object> isGccAvailable;
    private static LinkedHashSet<Path> systemIncludePathsC;
    private static LinkedHashSet<Path> systemIncludePathsCPP;
    public static final IncludeAutoDiscovery$ MODULE$;

    private IncludeAutoDiscovery$() {
    }

    static {
        MODULE$ = new IncludeAutoDiscovery$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        IsWin = Properties$.MODULE$.isWin();
        GccVersionCommand = (Seq)((SeqOps)new .colon.colon((Object)"gcc", (List)new .colon.colon((Object)"--version", (List)Nil$.MODULE$)));
        CppIncludeCommand = IsWin ? (Seq)((SeqOps)new .colon.colon((Object)"gcc", (List)new .colon.colon((Object)"-xc++", (List)new .colon.colon((Object)"-E", (List)new .colon.colon((Object)"-v", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)"nul", (List)Nil$.MODULE$)))))))) : (Seq)((SeqOps)new .colon.colon((Object)"gcc", (List)new .colon.colon((Object)"-xc++", (List)new .colon.colon((Object)"-E", (List)new .colon.colon((Object)"-v", (List)new .colon.colon((Object)"/dev/null", (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)"/dev/null", (List)Nil$.MODULE$))))))));
        CIncludeCommand = IsWin ? (Seq)((SeqOps)new .colon.colon((Object)"gcc", (List)new .colon.colon((Object)"-xc", (List)new .colon.colon((Object)"-E", (List)new .colon.colon((Object)"-v", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)"nul", (List)Nil$.MODULE$)))))))) : (Seq)((SeqOps)new .colon.colon((Object)"gcc", (List)new .colon.colon((Object)"-xc", (List)new .colon.colon((Object)"-E", (List)new .colon.colon((Object)"-v", (List)new .colon.colon((Object)"/dev/null", (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)"/dev/null", (List)Nil$.MODULE$))))))));
        VsWhereCommand = (Seq)((SeqOps)new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)new .colon.colon((Object)"\"%ProgramFiles(x86)%\\Microsoft Visual Studio\\Installer\\vswhere.exe\" -property installationPath", (List)Nil$.MODULE$))));
        VcVarsCommand = (Seq)((SeqOps)new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)new .colon.colon((Object)"VC\\Auxiliary\\Build\\vcvars64.bat", (List)Nil$.MODULE$))));
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"LC_ALL");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"C");
        LanguageSetting = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        isGccAvailable = None$.MODULE$;
        systemIncludePathsC = LinkedHashSet$.MODULE$.empty();
        systemIncludePathsCPP = LinkedHashSet$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IncludeAutoDiscovery$.class);
    }

    public LinkedHashSet<Path> discoverIncludePathsC(Config config) {
        if (!config.includePathsAutoDiscovery()) {
            return LinkedHashSet$.MODULE$.empty();
        }
        if (systemIncludePathsC.nonEmpty()) {
            return systemIncludePathsC;
        }
        if (this.isMSVCProject(config)) {
            systemIncludePathsCPP = this.discoverMSVCPaths();
            systemIncludePathsC = systemIncludePathsCPP;
            this.reportIncludePaths(systemIncludePathsC, "MSVC");
        }
        if (systemIncludePathsC.isEmpty() && this.gccAvailable()) {
            systemIncludePathsC = this.discoverPaths(CIncludeCommand);
            this.reportIncludePaths(systemIncludePathsC, "C");
        }
        return systemIncludePathsC;
    }

    public boolean gccAvailable() {
        Option<Object> option = isGccAvailable;
        if (option instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            isGccAvailable = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForGcc()));
            return BoxesRunTime.unboxToBoolean((Object)isGccAvailable.get());
        }
        throw new MatchError(option);
    }

    private boolean checkForGcc() {
        Try try_ = ExternalCommand$.MODULE$.run(GccVersionCommand, ExternalCommand$.MODULE$.run$default$2(), ExternalCommand$.MODULE$.run$default$3(), ExternalCommand$.MODULE$.run$default$4(), ExternalCommand$.MODULE$.run$default$5(), ExternalCommand$.MODULE$.run$default$6(), ExternalCommand$.MODULE$.run$default$7()).toTry();
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            logger.debug("GCC is available: " + result.mkString(System.lineSeparator()));
            return true;
        }
        logger.warn("GCC is not installed. Discovery of system include paths will not be available.");
        return false;
    }

    private LinkedHashSet<Path> discoverPaths(Seq<String> command) {
        Try<Seq<String>> try_ = GccSpecificExternalCommand$.MODULE$.run(command, ".", LanguageSetting);
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return this.extractPaths((Seq<String>)output);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Unable to discover system include paths. Running '" + command + "' failed.", exception);
            return LinkedHashSet$.MODULE$.empty();
        }
        throw new MatchError(try_);
    }

    private LinkedHashSet<Path> extractPaths(Seq<String> output) {
        int startIndex = output.indexWhere((Function1 & Serializable)_$1 -> _$1.contains("#include")) + 2;
        int endIndex = output.indexWhere((Function1 & Serializable)_$2 -> _$2.startsWith("End of search list."));
        return LinkedHashSet$.MODULE$.from((IterableOnce)((IterableOps)output.slice(startIndex, endIndex)).map((Function1 & Serializable)pathString -> {
            String trimmedPathString = pathString.trim();
            String macSpecificFix = trimmedPathString.contains(" (") && trimmedPathString.endsWith(")") ? trimmedPathString.substring(0, trimmedPathString.indexOf(" (")) : trimmedPathString;
            return Paths.get(macSpecificFix, new String[0]).toRealPath(new LinkOption[0]);
        }));
    }

    private LinkedHashSet<Path> discoverMSVCPaths() {
        return (LinkedHashSet)this.discoverMSVCInstallPath().map((Function1 & Serializable)resolvedInstallationPath -> MODULE$.extractMSVCIncludePaths((String)resolvedInstallationPath)).getOrElse(IncludeAutoDiscovery$::discoverMSVCPaths$$anonfun$2);
    }

    private Option<String> discoverMSVCInstallPath() {
        Try<Seq<String>> try_ = GccSpecificExternalCommand$.MODULE$.run(VsWhereCommand, ".", GccSpecificExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return output.headOption();
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Unable to discover MSVC installation path.", exception);
            return None$.MODULE$;
        }
        throw new MatchError(try_);
    }

    private LinkedHashSet<Path> extractMSVCIncludePaths(String resolvedInstallationPath) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"VSCMD_DEBUG");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"3");
        Try<Seq<String>> try_ = GccSpecificExternalCommand$.MODULE$.run(VcVarsCommand, resolvedInstallationPath, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        if (try_ instanceof Success) {
            Seq results = (Seq)((Success)try_).value();
            Option option = results.find((Function1 & Serializable)_$3 -> _$3.startsWith("INCLUDE="));
            if (option instanceof Some) {
                String includesLine = (String)((Some)option).value();
                String includesString = includesLine.replaceFirst("INCLUDE=", "");
                Object object = Predef$.MODULE$.refArrayOps((Object[])includesString.split(";"));
                return LinkedHashSet$.MODULE$.from((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)p -> Paths.get(p.trim(), new String[0]).toRealPath(new LinkOption[0]), ClassTag$.MODULE$.apply(Path.class))));
            }
            if (None$.MODULE$.equals(option)) {
                return LinkedHashSet$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Unable to discover MSVC system include paths.", exception);
            return LinkedHashSet$.MODULE$.empty();
        }
        throw new MatchError(try_);
    }

    private void reportIncludePaths(LinkedHashSet<Path> paths, String lang) {
        if (paths.nonEmpty()) {
            String ls = System.lineSeparator();
            logger.info("Using the following " + lang + " system include paths:" + paths.mkString(ls + "- ", ls + "- ", ls));
            return;
        }
    }

    private boolean isMSVCProject(Config config) {
        if (!IsWin) {
            return false;
        }
        Path projectDir = Paths.get(config.inputPath(), new String[0]);
        return ((List)new .colon.colon((Object)FileUtil$.MODULE$.PathExt(projectDir).$div(".vs"), (List)new .colon.colon((Object)FileUtil$.MODULE$.PathExt(projectDir).$div(".vscode"), (List)Nil$.MODULE$))).exists((Function1 & Serializable)_$4 -> Files.exists(_$4, new LinkOption[0])) || FileUtil$.MODULE$.PathExt(projectDir).listFiles().exists((Function1 & Serializable)_$5 -> FileUtil$.MODULE$.PathExt(_$5).extension(false).exists((Function1 & Serializable)ext -> {
            String string = ext;
            String string2 = "sln";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = ext;
            String string4 = "vcxproj";
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        }));
    }

    public LinkedHashSet<Path> discoverIncludePathsCPP(Config config) {
        if (!config.includePathsAutoDiscovery()) {
            return LinkedHashSet$.MODULE$.empty();
        }
        if (systemIncludePathsCPP.nonEmpty()) {
            return systemIncludePathsCPP;
        }
        if (this.isMSVCProject(config)) {
            systemIncludePathsCPP = this.discoverMSVCPaths();
            systemIncludePathsC = systemIncludePathsCPP;
            this.reportIncludePaths(systemIncludePathsCPP, "MSVC");
        }
        if (systemIncludePathsCPP.isEmpty() && this.gccAvailable()) {
            systemIncludePathsCPP = this.discoverPaths(CppIncludeCommand);
            this.reportIncludePaths(systemIncludePathsCPP, "CPP");
        }
        return systemIncludePathsCPP;
    }

    private static final LinkedHashSet discoverMSVCPaths$$anonfun$2() {
        return LinkedHashSet$.MODULE$.empty();
    }
}

