/*
 * Decompiled with CFR 0.152.
 */
package io.github.retronym.java9rtexport;

import io.github.retronym.java9rtexport.Copy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;

public class Export {
    private static final Object lock = new Object();
    private static File tempFile = null;
    public static String rtJarName = "rt-" + System.getProperty("java.version") + ".jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File rt() {
        try {
            Object object = lock;
            synchronized (object) {
                if (tempFile == null) {
                    Path tempPath = Files.createTempFile("rt", ".jar", new FileAttribute[0]);
                    tempFile = tempPath.toFile();
                    tempFile.deleteOnExit();
                    tempFile.delete();
                    FileSystem fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
                    Path path = fileSystem.getPath("/modules", new String[0]);
                    URI uri = URI.create("jar:" + String.valueOf(tempPath.toUri()));
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("create", "true");
                    try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
                        Iterator iterator = Files.list(path).iterator();
                        while (iterator.hasNext()) {
                            Path next = (Path)iterator.next();
                            Copy.copyDirectory((Path)next, (Path)zipfs.getPath("/", new String[0]));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return tempFile;
    }

    public static synchronized boolean rtTo(File dest, boolean verbose) {
        try {
            if (!dest.exists()) {
                if (verbose) {
                    System.out.println("Copying Java " + System.getProperty("java.version") + " runtime jar to " + String.valueOf(dest.getParentFile()) + " ...");
                    System.out.flush();
                }
                dest.getParentFile().mkdirs();
                Files.copy(Export.rt().toPath(), dest.toPath(), new CopyOption[0]);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return false;
    }

    public static File rtAt(File dir, boolean verbose) {
        File f = new File(dir, rtJarName);
        Export.rtTo(f, verbose);
        return f;
    }

    public static File rtAt(File dir) {
        return Export.rtAt(dir, false);
    }
}

