/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.cpgcreation;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import io.joern.console.ConsoleConfig;
import io.joern.console.cpgcreation.CpgGenerator;
import io.joern.console.cpgcreation.CpgGeneratorFactory$;
import io.joern.console.cpgcreation.package$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig$;
import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005eq!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003bB\u0013\u0002\u0005\u0004%IA\n\u0005\u0007o\u0005\u0001\u000b\u0011B\u0014\u0007\tm\u0001\u0002\u0001\u000f\u0005\ts\u0015\u0011\t\u0011)A\u0005u!)1%\u0002C\u0001}!)\u0011)\u0002C\u0001\u0005\")Q+\u0002C\u0001-\")\u0011,\u0002C\u00015\")q,\u0002C\u0001A\")A/\u0002C\u0001k\")Q0\u0002C\u0001}\"9\u0011\u0011C\u0003\u0005\n\u0005M\u0011aE\"qO\u001e+g.\u001a:bi>\u0014h)Y2u_JL(BA\t\u0013\u0003-\u0019\u0007oZ2sK\u0006$\u0018n\u001c8\u000b\u0005M!\u0012aB2p]N|G.\u001a\u0006\u0003+Y\tQA[8fe:T\u0011aF\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\u001b\u00035\t\u0001CA\nDa\u001e<UM\\3sCR|'OR1di>\u0014\u0018p\u0005\u0002\u0002;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\r\u0002\u001f-suj\u0016(`\u0019\u0006su)V!H\u000bN+\u0012a\n\t\u0004Q5zS\"A\u0015\u000b\u0005)Z\u0013!C5n[V$\u0018M\u00197f\u0015\tas$\u0001\u0006d_2dWm\u0019;j_:L!AL\u0015\u0003\u0007M+G\u000f\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!A.\u00198h\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003\rM#(/\u001b8h\u0003AYejT,O?2\u000bejR+B\u000f\u0016\u001b\u0006e\u0005\u0002\u0006;\u000511m\u001c8gS\u001e\u0004\"a\u000f\u001f\u000e\u0003II!!\u0010\n\u0003\u001b\r{gn]8mK\u000e{gNZ5h)\ty\u0004\t\u0005\u0002\u001b\u000b!)\u0011h\u0002a\u0001u\u0005Iam\u001c:D_\u0012,\u0017\t\u001e\u000b\u0003\u0007&\u00032A\b#G\u0013\t)uD\u0001\u0004PaRLwN\u001c\t\u00035\u001dK!\u0001\u0013\t\u0003\u0019\r\u0003xmR3oKJ\fGo\u001c:\t\u000b)C\u0001\u0019A&\u0002\u0013%t\u0007/\u001e;QCRD\u0007C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002O?5\tqJ\u0003\u0002Q1\u00051AH]8pizJ!AU\u0010\u0002\rA\u0013X\rZ3g\u0013\t1DK\u0003\u0002S?\u0005Yam\u001c:MC:<W/Y4f)\t\u0019u\u000bC\u0003Y\u0013\u0001\u00071*\u0001\u0005mC:<W/Y4f\u0003=a\u0017M\\4vC\u001e,\u0017j]&o_^tGCA._!\tqB,\u0003\u0002^?\t9!i\\8mK\u0006t\u0007\"\u0002-\u000b\u0001\u0004Y\u0015\u0001\u0004:v]\u001e+g.\u001a:bi>\u0014H\u0003B1pcJ\u00042AY3h\u001b\u0005\u0019'B\u00013 \u0003\u0011)H/\u001b7\n\u0005\u0019\u001c'a\u0001+ssB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005M&dWM\u0003\u0002mg\u0005\u0019a.[8\n\u00059L'\u0001\u0002)bi\"DQ\u0001]\u0006A\u0002\u0019\u000b\u0011bZ3oKJ\fGo\u001c:\t\u000b)[\u0001\u0019A&\t\u000bM\\\u0001\u0019A&\u0002\u0015=,H\u000f];u!\u0006$\b.A\u000ed_:4XM\u001d;Qe>$xn\u00119h)>|e/\u001a:gY><HI\u0019\u000b\u0004mf\\\bC\u0001\u0010x\u0013\tAxD\u0001\u0003V]&$\b\"\u0002>\r\u0001\u0004Y\u0015aC:sG\u001aKG.\u001a8b[\u0016DQ\u0001 \u0007A\u0002-\u000b1\u0002Z:u\r&dWM\\1nK\u0006I\u0011n\u001d.ja\u001aKG.\u001a\u000b\u00037~DaA[\u0007A\u0002\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006M&dWm\u001d\u0006\u0003\u0003\u0017\taAY3ui\u0016\u0014\u0018\u0002BA\b\u0003\u000b\u0011AAR5mK\u00061!/\u001a9peR$2A^A\u000b\u0011\u0019\t9B\u0004a\u0001\u0017\u0006\u00191\u000f\u001e:")
public class CpgGeneratorFactory {
    private final ConsoleConfig config;

    public Option<CpgGenerator> forCodeAt(String inputPath) {
        return package$.MODULE$.guessLanguage(inputPath).flatMap((Function1 & Serializable)language -> package$.MODULE$.cpgGeneratorForLanguage((String)language, $this.config.frontend(), $this.config.install().rootPath().path(), (List<String>)scala.package$.MODULE$.Nil()).map((Function1 & Serializable)cpgGenerator -> {
            this.report(new StringBuilder(32).append("Using generator for language: ").append((String)language).append(": ").append(cpgGenerator.getClass().getSimpleName()).toString());
            return cpgGenerator;
        }));
    }

    public Option<CpgGenerator> forLanguage(String language2) {
        return Option$.MODULE$.apply((Object)language2).filter((Function1 & Serializable)language -> BoxesRunTime.boxToBoolean((boolean)this.languageIsKnown(language))).flatMap((Function1 & Serializable)lang -> package$.MODULE$.cpgGeneratorForLanguage((String)lang, $this.config.frontend(), $this.config.install().rootPath().path(), (List<String>)scala.package$.MODULE$.Nil()));
    }

    public boolean languageIsKnown(String language) {
        return CpgGeneratorFactory$.MODULE$.io$joern$console$cpgcreation$CpgGeneratorFactory$$KNOWN_LANGUAGES().contains((Object)language);
    }

    public Try<Path> runGenerator(CpgGenerator generator, String inputPath, String outputPath) {
        Try outputFileOpt = generator.generate(inputPath, outputPath).map((Function1 & Serializable)x$1 -> File$.MODULE$.apply(x$1, (Seq)Nil$.MODULE$));
        return outputFileOpt.map((Function1 & Serializable)outFile -> {
            void var2_2;
            Object object;
            Path parentPath = outFile.parent().path().toAbsolutePath();
            if (this.isZipFile((File)outFile)) {
                this.report("Creating database from bin.zip");
                String srcFilename = ((Object)outFile.path().toAbsolutePath()).toString();
                String dstFilename = ((Object)parentPath.resolve("cpg.bin").toAbsolutePath()).toString();
                this.convertProtoCpgToOverflowDb(srcFilename, dstFilename);
                object = BoxedUnit.UNIT;
            } else {
                this.report("moving cpg.bin.zip to cpg.bin because it is already a database file");
                Path srcPath = parentPath.resolve("cpg.bin.zip");
                object = srcPath.toFile().exists() ? Dsl$.MODULE$.mv(File$.MODULE$.apply(srcPath), File$.MODULE$.apply(parentPath.resolve("cpg.bin"))) : BoxedUnit.UNIT;
            }
            return var2_2;
        });
    }

    public void convertProtoCpgToOverflowDb(String srcFilename, String dstFilename) {
        Config odbConfig = Config.withDefaults().withStorageLocation(dstFilename);
        CpgLoaderConfig config = CpgLoaderConfig$.MODULE$.withDefaults().doNotCreateIndexesOnLoad().withOverflowConfig(odbConfig);
        CpgLoader$.MODULE$.load(srcFilename, config).close();
        File qual$1 = File$.MODULE$.apply(srcFilename, (Seq)Nil$.MODULE$);
        boolean x$1 = qual$1.delete$default$1();
        Seq x$2 = qual$1.delete$default$2();
        qual$1.delete(x$1, x$2);
    }

    public boolean isZipFile(File file) {
        Iterator bytes = file.bytes();
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToByte((Object)bytes.next()) == 80 && BoxesRunTime.unboxToByte((Object)bytes.next()) == 75).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private void report(String str) {
        System.err.println(str);
    }

    public CpgGeneratorFactory(ConsoleConfig config) {
        this.config = config;
    }
}

