/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console;

import better.files.File$;
import flatgraph.help.Doc;
import flatgraph.help.Table;
import io.joern.console.Console$;
import io.joern.console.Console$ConsoleImageViewer$;
import io.joern.console.ConsoleConfig;
import io.joern.console.ConsoleConfig$;
import io.joern.console.Reporting;
import io.joern.console.cpgcreation.CpgGenerator;
import io.joern.console.cpgcreation.CpgGeneratorFactory;
import io.joern.console.cpgcreation.ImportCode;
import io.joern.console.workspacehandling.Project;
import io.joern.console.workspacehandling.WorkspaceLoader;
import io.joern.console.workspacehandling.WorkspaceManager;
import io.joern.x2cpg.X2Cpg$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyLanguage$;
import io.shiftleft.semanticcpg.Overlays$;
import io.shiftleft.semanticcpg.layers.LayerCreator;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Console<T extends Project>
implements Reporting {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Console.class.getDeclaredField("ConsoleImageViewer$lzy1"));
    private final WorkspaceLoader<T> loader;
    private final Table.AvailableWidthProvider availableWidthProvider;
    private final ConsoleConfig _config;
    private WorkspaceManager<T> workspaceManager;
    private final String nameOfCpgInProject;
    private volatile Object ConsoleImageViewer$lzy1;

    public static <T extends Project> String deriveNameFromInputPath(String string, WorkspaceManager<T> workspaceManager) {
        return Console$.MODULE$.deriveNameFromInputPath(string, workspaceManager);
    }

    public static String nameOfLegacyCpgInProject() {
        return Console$.MODULE$.nameOfLegacyCpgInProject();
    }

    public static <T extends Project> better.files.File $lessinit$greater$default$2() {
        return Console$.MODULE$.$lessinit$greater$default$2();
    }

    public Console(WorkspaceLoader<T> loader, better.files.File baseDir, Table.AvailableWidthProvider availableWidthProvider) {
        this.loader = loader;
        this.availableWidthProvider = availableWidthProvider;
        this._config = new ConsoleConfig(ConsoleConfig$.MODULE$.$lessinit$greater$default$1(), ConsoleConfig$.MODULE$.$lessinit$greater$default$2(), ConsoleConfig$.MODULE$.$lessinit$greater$default$3());
        this.switchWorkspace(baseDir.path().resolve("workspace").toString());
        this.nameOfCpgInProject = "cpg.bin";
    }

    public ConsoleConfig config() {
        return this._config;
    }

    public Console<T> console() {
        return this;
    }

    public WorkspaceManager<T> workspaceManager() {
        return this.workspaceManager;
    }

    public void workspaceManager_$eq(WorkspaceManager<T> x$1) {
        this.workspaceManager = x$1;
    }

    public String workspacePathName() {
        return this.workspaceManager().getPath();
    }

    public final Console$ConsoleImageViewer$ ConsoleImageViewer() {
        Object object = this.ConsoleImageViewer$lzy1;
        if (object instanceof Console$ConsoleImageViewer$) {
            return (Console$ConsoleImageViewer$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Console$ConsoleImageViewer$)this.ConsoleImageViewer$lzyINIT1();
    }

    private Object ConsoleImageViewer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ConsoleImageViewer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Console$ConsoleImageViewer$ console$ConsoleImageViewer$ = null;
                    try {
                        console$ConsoleImageViewer$ = new Console$ConsoleImageViewer$(this);
                        object2 = console$ConsoleImageViewer$ == null ? LazyVals.NullValue$.MODULE$ : console$ConsoleImageViewer$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ConsoleImageViewer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return console$ConsoleImageViewer$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Doc(info="Access to the workspace directory", longInfo="\n                 |All auditing projects are stored in a workspace directory, and `workspace`\n                 |provides programmatic access to this directory. Entering `workspace` provides\n                 |a list of all projects, indicating which code the project makes accessible,\n                 |whether the project is open, and which analyzers have been run to produce it.\n                 |Multiple projects can be open at any given time, however, only one project\n                 |can be active. Queries and edit-operations are executed on the active project\n                 |only.\n                 |\n                 |Operations\n                 |\n                 |----------\n                 |\n                 |`workspace` provides low-level access to the workspace directory. In most cases,\n                 |it is a better idea to use higher-level operations such as `importCode`, `open`,\n                 |`close`, and `delete`, which make use of workspace operations internally.\n                 |\n                 |* workspace.open([name]): open project by name and make it the active project.\n                 | If `name` is omitted, the last project in the workspace list is opened. If\n                 | the project is already open, this has the same effect as `workspace.setActiveProject([name])`\n                 |\n                 |* workspace.close([name]): close project by name. Does not remove the project.\n                 |\n                 |* workspace.remove([name]): close and remove project by name.\n                 |\n                 |* workspace.reset: create a fresh workspace directory, deleting the current\n                 |workspace directory\n                 |\n                 |", example="workspace")
    public WorkspaceManager<T> workspace() {
        return this.workspaceManager();
    }

    @Doc(info="Close current workspace and open a different one", longInfo=" | By default, the workspace in $INSTALL_DIR/workspace is used.\n                 | This method allows specifying a different workspace directory\n                 | via the `pathName` parameter.\n                 | Before changing the workspace, the current workspace will be\n                 | closed, saving any unsaved changes.\n                 | If `pathName` points to a non-existing directory, then a new\n                 | workspace is first created.\n                 |")
    public void switchWorkspace(String pathName) {
        if (this.workspaceManager() != null) {
            this.report("Saving current workspace before changing workspace");
            this.workspaceManager().projects().foreach((Function1 & Serializable)p -> p.close());
        }
        this.workspaceManager_$eq(new WorkspaceManager<T>(pathName, this.loader));
    }

    @Doc(info="Currently active project", example="project")
    public T project() {
        return (T)((Project)this.workspace().projectByCpg(this.cpg()).getOrElse(Console::project$$anonfun$1));
    }

    @Doc(info="CPG of the active project", longInfo="\n                 |Upon importing code, a project is created that holds\n                 |an intermediate representation called `Code Property Graph`. This\n                 |graph is a composition of low-level program representations such\n                 |as abstract syntax trees and control flow graphs, but it can be arbitrarily\n                 |extended to hold any information relevant in your audit, information\n                 |about HTTP entry points, IO routines, information flows, or locations\n                 |of vulnerable code. Think of Ocular and Joern as a CPG editors.\n                 |\n                 |In practice, `cpg` is the root object of the query language, that is, all\n                 |query language constructs can be invoked starting from `cpg`. For example,\n                 |`cpg.method.l` lists all methods, while `cpg.finding.l` lists all findings\n                 |of potentially vulnerable code.\n                 |", example="cpg.method.l")
    public Cpg cpg() {
        return this.workspace().cpg();
    }

    public Iterator<Cpg> cpgs() {
        if (this.workspace().projects().lastOption().isEmpty()) {
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        String activeProjectName = ((Project)this.project()).name();
        return this.workspace().projects().filter((Function1 & Serializable)_$1 -> _$1.cpg().isDefined()).iterator().flatMap((Function1 & Serializable)project -> {
            this.open(project.name());
            return Some$.MODULE$.apply(project.cpg());
        }).$plus$plus(() -> this.cpgs$$anonfun$3(activeProjectName)).flatten((Function1 & Serializable)iter -> io.shiftleft.semanticcpg.language.package$.MODULE$.iterableOnceToIterator((IterableOnce)iter));
    }

    public final <X> ItExtend<X> ItExtend(Iterator<X> it) {
        return new ItExtend<X>(this, it);
    }

    @Doc(info="Open project by name", longInfo="\n                 |open([projectName])\n                 |\n                 |Opens the project named `name` and make it the active project.\n                 |If `name` is not provided, the active project is opened. If `name`\n                 |is a path, the project name is derived from and a deprecation\n                 |warning is printed.\n                 |\n                 |Upon completion of this operation, the CPG stored in this project\n                 |can be queried via `cpg`. Returns an optional reference to the\n                 |project, which is empty on error.\n                 |", example="open(\"projectName\")")
    public Option<Project> open(String name) {
        String projectName = this.fixProjectNameAndComplainOnFix(name);
        WorkspaceManager<T> workspaceManager = this.workspace();
        return workspaceManager.openProject(projectName, workspaceManager.openProject$default$2()).map((Function1 & Serializable)project -> project);
    }

    @Doc(info="Open project for input path", longInfo="\n                 |openForInputPath([input-path])\n                 |\n                 |Opens the project of the CPG generated for the input path `input-path`.\n                 |\n                 |Upon completion of this operation, the CPG stored in this project\n                 |can be queried via `cpg`. Returns an optional reference to the\n                 |project, which is empty on error.\n                 |")
    public Option<Project> openForInputPath(String inputPath) {
        String absInputPath = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().toString();
        return this.workspace().projects().filter((Function1 & Serializable)x -> {
            String string = x.inputPath();
            String string2 = absInputPath;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$2 -> _$2.name()).map((Function1 & Serializable)name -> this.open((String)name)).headOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<Project> open() {
        return this.workspace().projects().lastOption().flatMap((Function1 & Serializable)p -> this.open(p.name()));
    }

    @Doc(info="Close and remove project from disk", example="delete(projectName)")
    public Option<BoxedUnit> delete(String name2) {
        this.workspaceManager().getActiveProject().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.cpg().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.close()));
        WorkspaceManager workspaceManager = this.workspace();
        return this.defaultProjectNameIfEmpty(name2).flatMap((Function1 & Serializable)name -> workspaceManager.deleteProject((String)name));
    }

    @Doc(info="Exit the REPL")
    public void exit() {
        this.workspace().projects().foreach((Function1 & Serializable)_$5 -> _$5.close());
        System.exit(0);
    }

    public Option<BoxedUnit> delete() {
        return this.delete("");
    }

    public Option<String> defaultProjectNameIfEmpty(String name) {
        if (name.isEmpty()) {
            Option projectNameOpt = this.workspace().projectByCpg(this.cpg()).map((Function1 & Serializable)_$6 -> _$6.name());
            if (projectNameOpt.isEmpty()) {
                this.report("Fatal: cannot find project for active CPG");
            }
            return projectNameOpt;
        }
        return Some$.MODULE$.apply((Object)this.fixProjectNameAndComplainOnFix(name));
    }

    @Doc(info="Write all changes to disk", longInfo="\n                 |Close and reopen all loaded CPGs. This ensures\n                 |that changes have been flushed to disk.\n                 |\n                 |Returns list of affected projects\n                 |", example="save")
    public List<Project> save() {
        this.report("Saving graphs on disk. This may take a while.");
        return (List)this.workspace().projects().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ Console $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Project x) {
                Project p;
                Project project = x;
                return project != null && (p = project).cpg().isDefined();
            }

            public final Object applyOrElse(Project x, Function1 function1) {
                Project p;
                Project project = x;
                if (project != null && (p = project).cpg().isDefined()) {
                    p.close();
                    WorkspaceManager<T> workspaceManager = this.$outer.workspace();
                    return workspaceManager.openProject(p.name(), workspaceManager.openProject$default$2());
                }
                return function1.apply((Object)x);
            }
        }).flatten((Function1 & Serializable)iter -> io.shiftleft.semanticcpg.language.package$.MODULE$.iterableOnceToIterator((IterableOnce)iter));
    }

    @Doc(info="Create new project from code", longInfo="\n                 |importCode(<inputPath>, [projectName], [namespaces], [language])\n                 |\n                 |Type `importCode` alone to get a list of all supported languages\n                 |\n                 |Import code at `inputPath`. Creates a new project, generates a CPG,\n                 |and opens the project. Upon success, the CPG can be queried via the `cpg`\n                 |object. Default overlays are already applied to the newly created CPG.\n                 |Returns new CPG and ensures that `cpg` now refers to this new CPG.\n                 |\n                 |By default, `importCode` attempts to guess the source language of\n                 |the code you provide. You can also specify the source language\n                 |manually, by running `importCode.<language>`. For example, `importCode.c`\n                 |runs the C/C++ frontend.\n                 |\n                 |Type `importCode` alone to get an overview of all available language modules.\n                 |\n                 |Parameters:\n                 |\n                 |-----------\n                 |\n                 |inputPath: location on disk of the code to analyze. e.g., a directory\n                 |containing source code or a Java archive (JAR).\n                 |\n                 |projectName: a unique name used for project management. If this parameter\n                 |is omitted, the name will be derived from `inputPath`\n                 |\n                 |namespaces: the whitelist of namespaces to analyse. Specifying this\n                 |parameter is only effective if the language frontend supports it.\n                 |If the list is omitted or empty, namespace selection is performed\n                 |automatically via heuristics.\n                 |\n                 |language: the programming language which the code at `inputPath` is written in.\n                 |If `language` is empty, the language used is guessed by inspecting\n                 |the filename found and possibly by looking into the file/directory.\n                 |\n                 |", example="importCode(\"example.jar\")")
    public ImportCode<T> importCode() {
        return new ImportCode(this, this.availableWidthProvider);
    }

    @Doc(info="Create new project from existing CPG", longInfo="\n                 |importCpg(<inputPath>, [projectName], [enhance])\n                 |\n                 |Import an existing CPG. The CPG is stored as part\n                 |of a new project and blanks are filled in by analyzing the CPG.\n                 |If we find that default overlays have not been applied, these\n                 |are applied to the CPG after loading it.\n                 |\n                 |Parameters:\n                 |\n                 |inputPath: path where the existing CPG (in overflowdb format)\n                 |is stored\n                 |\n                 |projectName: name of the new project. If this parameter\n                 |is omitted, the path is derived from `inputPath`\n                 |\n                 |enhance: run default overlays and post-processing passes. Defaults to `true`.\n                 |Pass `enhance=false` to disable the enhancements.\n                 |", example="importCpg(\"cpg.bin.zip\")")
    public Option<Cpg> importCpg(String inputPath, String projectName, boolean enhance) {
        Option cpgOpt;
        better.files.File file;
        String name = (String)Option$.MODULE$.apply((Object)projectName).filter((Function1 & Serializable)_$7 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$7))).getOrElse(() -> this.$anonfun$3(inputPath));
        better.files.File cpgFile = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!cpgFile.exists(cpgFile.exists$default$1())) {
            this.report("CPG at " + inputPath + " does not exist. Bailing out.");
            return None$.MODULE$;
        }
        System.err.println("Creating project `" + name + "` for CPG at `" + inputPath + "`");
        Option<Path> pathToProject = this.workspace().createProject(inputPath, name);
        Option cpgDestinationPathOpt = pathToProject.map((Function1 & Serializable)_$8 -> _$8.resolve(this.nameOfCpgInProject));
        if (cpgDestinationPathOpt.isEmpty()) {
            this.report("Error creating project for input path: `" + inputPath + "`");
            return None$.MODULE$;
        }
        Path cpgDestinationPath = (Path)cpgDestinationPathOpt.get();
        boolean isProtoFormat = CpgLoader$.MODULE$.isProtoFormat(cpgFile.path());
        boolean isOverflowDbFormat = CpgLoader$.MODULE$.isOverflowDbFormat(cpgFile.path());
        if (isProtoFormat || isOverflowDbFormat) {
            if (isProtoFormat) {
                this.report("You have provided a legacy proto CPG. Attempting conversion.");
            } else if (isOverflowDbFormat) {
                this.report("You have provided a legacy overflowdb CPG. Attempting conversion.");
            }
            try {
                Cpg cpg2 = CpgLoader$.MODULE$.load(cpgFile.path(), cpgDestinationPath);
                cpg2.close();
                file = BoxedUnit.UNIT;
            }
            catch (Exception exc) {
                this.report("Error converting legacy CPG: " + exc.getMessage());
                return None$.MODULE$;
            }
        } else {
            better.files.File file2 = File$.MODULE$.apply(cpgDestinationPath);
            file = cpgFile.copyTo(file2, true, cpgFile.copyTo$default$3(file2, true));
        }
        if ((cpgOpt = this.open(name).flatMap((Function1 & Serializable)_$9 -> _$9.cpg())).isEmpty()) {
            this.workspace().deleteProject(name);
        }
        if (enhance) {
            cpgOpt.filter((Function1 & Serializable)_$10 -> io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(_$10).metaData().hasNext()).foreach((Function1 & Serializable)cpg -> {
                this.applyDefaultOverlays((Cpg)cpg);
                return this.applyPostProcessingPasses((Cpg)cpg);
            });
        }
        return cpgOpt;
    }

    public String importCpg$default$2() {
        return "";
    }

    public boolean importCpg$default$3() {
        return true;
    }

    @Doc(info="Close project by name", longInfo="|Close project. Resources are freed but the project remains on disk.\n                  |The project remains active, that is, calling `cpg` now raises an\n                  |exception. A different project can now be activated using `open`.\n                  |", example="close(projectName)")
    public Option<Project> close(String name2) {
        WorkspaceManager workspaceManager = this.workspace();
        return this.defaultProjectNameIfEmpty(name2).flatMap((Function1 & Serializable)name -> workspaceManager.closeProject((String)name));
    }

    public Option<Project> close() {
        return this.close("");
    }

    public Option<Project> reload(String name) {
        return this.close(name).flatMap((Function1 & Serializable)p -> this.open(p.name()));
    }

    public Cpg applyPostProcessingPasses(Cpg cpg) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyLanguageTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg).metaData());
        Option<CpgGenerator> option = new CpgGeneratorFactory(this._config).forLanguage((String)this.ItExtend(TraversalPropertyLanguage$.MODULE$.language$extension(iterator)).l().head());
        if (option instanceof Some) {
            CpgGenerator frontend = (CpgGenerator)((Some)option).value();
            return frontend.applyPostProcessingPasses(cpg);
        }
        if (None$.MODULE$.equals(option)) {
            return cpg;
        }
        throw new MatchError(option);
    }

    public Cpg applyDefaultOverlays(Cpg cpg) {
        Seq appliedOverlays = Overlays$.MODULE$.appliedOverlays(cpg);
        if (appliedOverlays.isEmpty()) {
            this.report("Adding default overlays to base CPG");
            this._runAnalyzer((Seq<LayerCreator>)X2Cpg$.MODULE$.defaultOverlayCreators());
        }
        return cpg;
    }

    public Cpg _runAnalyzer(Seq<LayerCreator> overlayCreators) {
        overlayCreators.foreach((Function1)(JProcedure1 & Serializable)creator -> {
            String overlayDirName = this.workspace().getNextOverlayDirName(this.cpg(), creator.overlayName());
            Option<T> projectOpt = this.workspace().projectByCpg(this.cpg());
            if (projectOpt.isEmpty()) {
                throw new RuntimeException("No record for CPG. Please use `importCode`/`importCpg/open`");
            }
            if (((Project)projectOpt.get()).appliedOverlays().contains((Object)creator.overlayName())) {
                this.report("Overlay " + creator.overlayName() + " already exists - skipping");
                return;
            }
            better.files.File file = File$.MODULE$.apply(overlayDirName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
            this.runCreator((LayerCreator)creator, (Option<String>)Some$.MODULE$.apply((Object)overlayDirName));
        });
        this.report("The graph has been modified. You may want to use the `save` command to persist changes to disk.  All changes will also be saved collectively on exit");
        return this.cpg();
    }

    public void runCreator(LayerCreator creator, Option<String> overlayDirName) {
        LayerCreatorContext context = new LayerCreatorContext(this.cpg(), overlayDirName);
        creator.run(context);
    }

    public String fixProjectNameAndComplainOnFix(String name) {
        String projectName = (String)Some$.MODULE$.apply((Object)name).filter((Function1 & Serializable)_$11 -> _$11.contains(File.separator)).map((Function1 & Serializable)x -> Console$.MODULE$.deriveNameFromInputPath((String)x, this.workspace())).getOrElse(() -> Console.$anonfun$8(name));
        String string = name;
        String string2 = projectName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            System.err.println("Passing paths to `loadCpg` is deprecated, please use a project name");
        }
        return projectName;
    }

    private static final Project project$$anonfun$1() {
        throw new RuntimeException("No active project");
    }

    private final IterableOnce cpgs$$anonfun$3(String activeProjectName$1) {
        Iterator$ iterator$ = package$.MODULE$.Iterator();
        Object[] objectArray = new None$[1];
        this.open(activeProjectName$1);
        objectArray[0] = None$.MODULE$;
        return iterator$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final String $anonfun$3(String inputPath$1) {
        return Console$.MODULE$.deriveNameFromInputPath(inputPath$1, this.workspace());
    }

    private static final String $anonfun$8(String name$1) {
        return name$1;
    }

    public class ItExtend<X> {
        private final Iterator<X> it;
        private final /* synthetic */ Console $outer;

        public ItExtend(Console $outer, Iterator<X> it) {
            this.it = it;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public List<X> l() {
            return this.it.toList();
        }

        public final /* synthetic */ Console io$joern$console$Console$ItExtend$$$outer() {
            return this.$outer;
        }
    }
}

