/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console;

import better.files.File;
import better.files.File$;
import io.joern.console.BridgeBase;
import io.joern.console.Config;
import io.joern.console.InstallConfig$;
import io.joern.console.PluginManager;
import io.joern.console.cpgcreation.package$;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.text.StringEscapeUtils;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface PluginHandling {
    public static void printPluginsAndLayerCreators$(PluginHandling $this, Config config) {
        $this.printPluginsAndLayerCreators(config);
    }

    default public void printPluginsAndLayerCreators(Config config) {
        Predef$.MODULE$.println((Object)"Installed plugins:");
        Predef$.MODULE$.println((Object)"==================");
        new PluginManager(InstallConfig$.MODULE$.apply().rootPath()).listPlugins().foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
        Predef$.MODULE$.println((Object)"Available layer creators");
        Predef$.MODULE$.println();
        this.withTemporaryScript(this.codeToListPlugins(), (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)file -> ((BridgeBase)this).runScript(config.copy((Option<Path>)Some$.MODULE$.apply((Object)file.path()), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9(), config.copy$default$10(), config.copy$default$11(), config.copy$default$12(), config.copy$default$13(), config.copy$default$14(), config.copy$default$15(), config.copy$default$16(), config.copy$default$17(), config.copy$default$18(), config.copy$default$19(), config.copy$default$20(), config.copy$default$21(), config.copy$default$22(), config.copy$default$23(), config.copy$default$24(), config.copy$default$25(), config.copy$default$26(), config.copy$default$27())).get());
    }

    private String codeToListPlugins() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |println(run)\n      |\n      |"));
    }

    public static void runPlugin$(PluginHandling $this, Config config) {
        $this.runPlugin(config);
    }

    default public void runPlugin(Config config) {
        if (config.src().isEmpty()) {
            Predef$.MODULE$.println((Object)"You must supply a source directory with the --src flag");
            return;
        }
        String code = this.loadOrCreateCpg(config, ((BridgeBase)this).applicationName());
        this.withTemporaryScript(code, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)file -> ((BridgeBase)this).runScript(config.copy((Option<Path>)Some$.MODULE$.apply((Object)file.path()), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9(), config.copy$default$10(), config.copy$default$11(), config.copy$default$12(), config.copy$default$13(), config.copy$default$14(), config.copy$default$15(), config.copy$default$16(), config.copy$default$17(), config.copy$default$18(), config.copy$default$19(), config.copy$default$20(), config.copy$default$21(), config.copy$default$22(), config.copy$default$23(), config.copy$default$24(), config.copy$default$25(), config.copy$default$26(), config.copy$default$27())).get());
    }

    private String loadOrCreateCpg(Config config, String productName) {
        String bundleName = (String)config.pluginToRun().get();
        String srcRaw = File$.MODULE$.apply((String)config.src().get(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().toString();
        String src = StringEscapeUtils.escapeJava((String)srcRaw);
        String language = this.languageFromConfig(config, src);
        String storeCode = config.store() ? "save" : "";
        String string = productName;
        String string2 = "ocular";
        String runDataflow = !(string != null ? !string.equals(string2) : string2 != null) ? "run.dataflow" : "run.ossdataflow";
        String argsString = this.argsStringFromConfig(config);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       | if (" + config.overwrite() + " || !workspace.projectExists(\"" + src + "\")) {\n       |   workspace.projects\n       |   .filter(_.inputPath == \"" + src + "\")\n       |   .map(_.name).foreach(n => workspace.removeProject(n))\n       |   importCode." + language + "(\"" + src + "\"" + argsString + ")\n       |   " + runDataflow + "\n       |   save\n       | } else {\n       |    println(\"Using existing CPG - Use `--overwrite` if this is not what you want\")\n       |    openForInputPath(\"" + src + "\")\n       | }\n       | run." + bundleName + "\n       | " + storeCode + "\n       |"));
    }

    private String languageFromConfig(Config config, String src) {
        return (String)config.language().getOrElse(() -> PluginHandling.languageFromConfig$$anonfun$1(src));
    }

    private String argsStringFromConfig(Config config) {
        Object object;
        Object[] objectArray = config.frontendArgs();
        if (objectArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)objectArray), 0) == 0) {
            return "";
        }
        Object[] args = objectArray;
        Object object2 = Predef$.MODULE$.refArrayOps(args);
        Object[] quotedArgs = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)arg -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("\""), arg)), "\""), ClassTag$.MODULE$.apply(String.class));
        String argsString = Predef$.MODULE$.wrapRefArray(quotedArgs).mkString(", ");
        return ", args=List(" + argsString + ")";
    }

    private void withTemporaryScript(String code, Function1<File, BoxedUnit> f) {
        File$.MODULE$.usingTemporaryDirectory(((BridgeBase)this).applicationName() + "-bundle", File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)dir -> {
            File file = dir.$div("script.sc");
            file.write(code, file.write$default$2(code), file.write$default$3(code));
            f.apply((Object)file);
        });
    }

    private static String languageFromConfig$$anonfun$1$$anonfun$2() {
        return "c";
    }

    private static String languageFromConfig$$anonfun$1(String src$18) {
        return (String)package$.MODULE$.guessLanguage(src$18).map((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1101867934: {
                    if (!"JAVASRC".equals(string)) break;
                    return "java";
                }
                case 67: {
                    if ("C".equals(string)) return "c";
                    break;
                }
                case 0x22A222: {
                    if (!"JAVA".equals(string)) break;
                    return "jvm";
                }
                case 2392771: {
                    if (!"NEWC".equals(string)) break;
                    return "c";
                }
            }
            String lang = string;
            return lang.toLowerCase();
        }).getOrElse(PluginHandling::languageFromConfig$$anonfun$1$$anonfun$2);
    }
}

