/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class PluginManager {
    private final File installDir;

    public PluginManager(File installDir) {
        this.installDir = installDir;
    }

    public File installDir() {
        return this.installDir;
    }

    public List<String> listPlugins() {
        List installedPluginNames = (List)((StrictOptimizedSeqOps)this.pluginDir().toList().flatMap((Function1 & Serializable)dir -> File$.MODULE$.apply(dir).list().toList().flatMap((Function1 & Serializable)f -> StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^joernext-(.*?)-.*$")).findAllIn((CharSequence)f.name()).matchData().map((Function1 & Serializable)m -> m.group(1)))).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return installedPluginNames;
    }

    public void add(String filename) {
        if (this.pluginDir().isEmpty()) {
            Predef$.MODULE$.println((Object)"Plugin directory does not exist");
            return;
        }
        File file = File$.MODULE$.apply(filename, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!file.exists(file.exists$default$1())) {
            Predef$.MODULE$.println((Object)("The file " + filename + " does not exist"));
            return;
        }
        this.addExisting(file);
    }

    private void addExisting(File file) {
        String pluginName = file.name().replace(".zip", "");
        Option<File> tmpDir = this.extractToTemporaryDir(file);
        tmpDir.foreach((Function1)(JProcedure1 & Serializable)dir -> this.addExistingUnzipped((File)dir, pluginName));
    }

    private void addExistingUnzipped(File file, String pluginName) {
        file.listRecursively(file.listRecursively$default$1()).filter((Function1 & Serializable)_$1 -> _$1.name().endsWith(".jar")).foreach((Function1)(JProcedure1 & Serializable)jar -> this.pluginDir().foreach((Function1)(JProcedure1 & Serializable)pDir -> {
            File file = File$.MODULE$.apply(pDir).$div(jar.name());
            if (!file.exists(file.exists$default$1())) {
                String dstFileName = "joernext-" + pluginName + "-" + jar.name();
                File dstFile = File$.MODULE$.apply(pDir).$div(dstFileName);
                Dsl$.MODULE$.cp(jar, dstFile);
                return;
            }
        }));
    }

    private Option<File> extractToTemporaryDir(File file) {
        Try try_ = Try$.MODULE$.apply(() -> PluginManager.extractToTemporaryDir$$anonfun$1(file));
        if (try_ instanceof Success) {
            File dir = (File)((Success)try_).value();
            return Some$.MODULE$.apply((Object)dir);
        }
        if (try_ instanceof Failure) {
            Throwable exc = ((Failure)try_).exception();
            Predef$.MODULE$.println((Object)("Error reading zip: " + exc.getMessage()));
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public List<String> rm(String name) {
        if (!this.listPlugins().contains((Object)name)) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        List filesToRemove = this.pluginDir().toList().flatMap((Function1 & Serializable)dir -> File$.MODULE$.apply(dir).list().filter((Function1 & Serializable)f -> f.name().startsWith("joernext-" + name)));
        filesToRemove.foreach((Function1 & Serializable)f -> f.delete(f.delete$default$1(), f.delete$default$2()));
        return filesToRemove.map((Function1 & Serializable)_$2 -> _$2.pathAsString());
    }

    public Option<Path> pluginDir() {
        Path pathToPluginDir = this.installDir().path().resolve("lib");
        if (pathToPluginDir.toFile().exists()) {
            return Some$.MODULE$.apply((Object)pathToPluginDir);
        }
        Predef$.MODULE$.println((Object)("Plugin directory at " + pathToPluginDir + " does not exist"));
        return None$.MODULE$;
    }

    private static final File extractToTemporaryDir$$anonfun$1(File file$1) {
        Function1 function1 = file$1.unzip$default$1();
        return file$1.unzip(function1, file$1.unzip$default$2(function1));
    }
}

