/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.cpgcreation;

import io.joern.console.FrontendConfig;
import io.joern.console.cpgcreation.CSharpCpgGenerator$;
import io.joern.console.cpgcreation.CpgGenerator;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Try;

public class CSharpCpgGenerator
extends CpgGenerator
implements Product,
Serializable {
    private final FrontendConfig config;
    private final Path rootPath;

    public static CSharpCpgGenerator apply(FrontendConfig frontendConfig, Path path) {
        return CSharpCpgGenerator$.MODULE$.apply(frontendConfig, path);
    }

    public static CSharpCpgGenerator fromProduct(Product product) {
        return CSharpCpgGenerator$.MODULE$.fromProduct(product);
    }

    public static CSharpCpgGenerator unapply(CSharpCpgGenerator cSharpCpgGenerator) {
        return CSharpCpgGenerator$.MODULE$.unapply(cSharpCpgGenerator);
    }

    public CSharpCpgGenerator(FrontendConfig config, Path rootPath) {
        this.config = config;
        this.rootPath = rootPath;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CSharpCpgGenerator)) return false;
        CSharpCpgGenerator cSharpCpgGenerator = (CSharpCpgGenerator)object;
        FrontendConfig frontendConfig = this.config();
        FrontendConfig frontendConfig2 = cSharpCpgGenerator.config();
        if (frontendConfig == null) {
            if (frontendConfig2 != null) {
                return false;
            }
        } else if (!frontendConfig.equals(frontendConfig2)) return false;
        Path path = this.rootPath();
        Path path2 = cSharpCpgGenerator.rootPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        if (!cSharpCpgGenerator.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CSharpCpgGenerator;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "CSharpCpgGenerator";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "config";
        }
        if (1 == n2) {
            return "rootPath";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public FrontendConfig config() {
        return this.config;
    }

    public Path rootPath() {
        return this.rootPath;
    }

    @Override
    public Try<String> generate(String inputPath, String outputPath) {
        if (this.commercialAvailable()) {
            return this.generateCommercial(inputPath, outputPath);
        }
        if (this.ossAvailable()) {
            return this.generateOss(inputPath, outputPath);
        }
        return Failure$.MODULE$.apply((Throwable)((Object)new AssertionError((Object)"No C# language frontend present")));
    }

    @Override
    public String generate$default$2() {
        return "cpg.bin.zip";
    }

    private Try<String> generateCommercial(String inputPath, String outputPath) {
        Seq arguments = (Seq)((SeqOps)new .colon.colon((Object)"-i", (List)new .colon.colon((Object)inputPath, (List)new .colon.colon((Object)"-o", (List)new .colon.colon((Object)outputPath, (List)Nil$.MODULE$))))).$plus$plus(this.config().cmdLineParams());
        String command = this.rootPath().resolve("csharp2cpg.sh").toString();
        if (System.getProperty("os.name").startsWith("Windows")) {
            command = "powershell";
            arguments = (Seq)((SeqOps)new .colon.colon((Object)this.rootPath().resolve("csharp2cpg.ps1").toString(), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)arguments);
        }
        return this.runShellCommand(command, (Seq<String>)arguments).map((Function1 & Serializable)_$1 -> outputPath);
    }

    private String generateCommercial$default$2() {
        return "cpg.bin.zip";
    }

    private Try<String> generateOss(String inputPath, String outputPath) {
        Path command = this.isWin() ? this.rootPath().resolve("csharpsrc2cpg.bat") : this.rootPath().resolve("csharpsrc2cpg");
        Seq arguments = (Seq)this.config().cmdLineParams().toSeq().$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)inputPath, (List)new .colon.colon((Object)"--output", (List)new .colon.colon((Object)outputPath, (List)Nil$.MODULE$)))));
        return this.runShellCommand(command.toString(), (Seq<String>)arguments).map((Function1 & Serializable)_$2 -> outputPath);
    }

    @Override
    public boolean isAvailable() {
        return this.commercialAvailable() || this.ossAvailable();
    }

    private boolean commercialAvailable() {
        return this.rootPath().resolve("csharp2cpg.sh").toFile().exists();
    }

    private boolean ossAvailable() {
        return this.rootPath().resolve("csharpsrc2cpg").toFile().exists();
    }

    @Override
    public boolean isJvmBased() {
        return false;
    }

    public CSharpCpgGenerator copy(FrontendConfig config, Path rootPath) {
        return new CSharpCpgGenerator(config, rootPath);
    }

    public FrontendConfig copy$default$1() {
        return this.config();
    }

    public Path copy$default$2() {
        return this.rootPath();
    }

    public FrontendConfig _1() {
        return this.config();
    }

    public Path _2() {
        return this.rootPath();
    }
}

