/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.cpgcreation;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import io.joern.console.ConsoleConfig;
import io.joern.console.CpgConverter$;
import io.joern.console.cpgcreation.CpgGenerator;
import io.joern.console.cpgcreation.CpgGeneratorFactory$;
import io.joern.console.cpgcreation.package$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public class CpgGeneratorFactory {
    private final ConsoleConfig config;

    public CpgGeneratorFactory(ConsoleConfig config) {
        this.config = config;
    }

    public Option<CpgGenerator> forCodeAt(String inputPath) {
        return package$.MODULE$.guessLanguage(inputPath).flatMap((Function1 & Serializable)language -> package$.MODULE$.cpgGeneratorForLanguage((String)language, this.config.frontend(), this.config.install().rootPath().path(), (List<String>)scala.package$.MODULE$.Nil()).map((Function1 & Serializable)cpgGenerator -> {
            this.report("Using generator for language: " + language + ": " + cpgGenerator.getClass().getSimpleName());
            return cpgGenerator;
        }));
    }

    public Option<CpgGenerator> forLanguage(String language2) {
        return Option$.MODULE$.apply((Object)language2).filter((Function1 & Serializable)language -> this.languageIsKnown((String)language)).flatMap((Function1 & Serializable)lang -> package$.MODULE$.cpgGeneratorForLanguage((String)lang, this.config.frontend(), this.config.install().rootPath().path(), (List<String>)scala.package$.MODULE$.Nil()));
    }

    public boolean languageIsKnown(String language) {
        return CpgGeneratorFactory$.io$joern$console$cpgcreation$CpgGeneratorFactory$$$KNOWN_LANGUAGES.contains((Object)language);
    }

    public Try<Path> runGenerator(CpgGenerator generator, String inputPath, String outputPath) {
        Try outputFileOpt = generator.generate(inputPath, outputPath).map((Function1 & Serializable)_$1 -> File$.MODULE$.apply(_$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
        return outputFileOpt.map((Function1 & Serializable)outFile -> {
            Path parentPath = outFile.parent().path().toAbsolutePath();
            if (CpgLoader$.MODULE$.isProtoFormat(outFile.path())) {
                this.report("Creating database from bin.zip");
                String srcFilename = outFile.path().toAbsolutePath().toString();
                String dstFilename = parentPath.resolve("cpg.bin").toAbsolutePath().toString();
                this.convertProtoCpgToFlatgraph(srcFilename, dstFilename);
            } else {
                this.report("moving cpg.bin.zip to cpg.bin because it is already a database file");
                Path srcPath = parentPath.resolve("cpg.bin.zip");
                if (srcPath.toFile().exists()) {
                    Dsl$.MODULE$.mv(File$.MODULE$.apply(srcPath), File$.MODULE$.apply(parentPath.resolve("cpg.bin")));
                }
            }
            return parentPath;
        });
    }

    public void convertProtoCpgToOverflowDb(String srcFilename, String dstFilename) {
        this.convertProtoCpgToFlatgraph(srcFilename, dstFilename);
    }

    public void convertProtoCpgToFlatgraph(String srcFilename, String dstFilename) {
        CpgConverter$.MODULE$.convertProtoCpgToFlatgraph(srcFilename, dstFilename);
        File file = File$.MODULE$.apply(srcFilename, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        file.delete(file.delete$default$1(), file.delete$default$2());
    }

    private void report(String str) {
        System.err.println(str);
    }
}

