/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.cpgcreation;

import better.files.File;
import better.files.File$;
import flatgraph.help.Table;
import flatgraph.help.Table$;
import io.joern.console.Console;
import io.joern.console.Console$;
import io.joern.console.ConsoleConfig;
import io.joern.console.ConsoleException;
import io.joern.console.FrontendConfig;
import io.joern.console.Reporting;
import io.joern.console.cpgcreation.CpgGenerator;
import io.joern.console.cpgcreation.CpgGeneratorFactory;
import io.joern.console.cpgcreation.ImportCode$BinaryFrontend$;
import io.joern.console.cpgcreation.ImportCode$CFrontend$;
import io.joern.console.cpgcreation.ImportCode$Frontend$;
import io.joern.console.cpgcreation.package$;
import io.joern.console.workspacehandling.Project;
import io.joern.console.workspacehandling.WorkspaceManager;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class ImportCode<T extends Project>
implements Reporting {
    public final Console<T> io$joern$console$cpgcreation$ImportCode$$console;
    public final Table.AvailableWidthProvider io$joern$console$cpgcreation$ImportCode$$availableWidthProvider;
    public final ConsoleConfig io$joern$console$cpgcreation$ImportCode$$config;
    private final WorkspaceManager<T> workspace;
    private final CpgGeneratorFactory generatorFactory;
    public final ImportCode$Frontend$ Frontend$lzy1;
    public final ImportCode$BinaryFrontend$ BinaryFrontend$lzy1;
    public final ImportCode$CFrontend$ CFrontend$lzy1;

    public ImportCode(Console<T> console, Table.AvailableWidthProvider availableWidthProvider) {
        this.io$joern$console$cpgcreation$ImportCode$$console = console;
        this.io$joern$console$cpgcreation$ImportCode$$availableWidthProvider = availableWidthProvider;
        this.Frontend$lzy1 = new ImportCode$Frontend$();
        this.BinaryFrontend$lzy1 = new ImportCode$BinaryFrontend$();
        this.CFrontend$lzy1 = new ImportCode$CFrontend$();
        this.io$joern$console$cpgcreation$ImportCode$$config = console.config();
        this.workspace = console.workspace();
        this.generatorFactory = new CpgGeneratorFactory(this.io$joern$console$cpgcreation$ImportCode$$config);
    }

    public CpgGeneratorFactory generatorFactory() {
        return this.generatorFactory;
    }

    public void io$joern$console$cpgcreation$ImportCode$$checkInputPath(String inputPath) {
        File file = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!file.exists(file.exists$default$1())) {
            throw new ConsoleException("Input path does not exist: '" + inputPath + "'");
        }
    }

    public Cpg apply(String inputPath, String projectName, String language) {
        this.io$joern$console$cpgcreation$ImportCode$$checkInputPath(inputPath);
        String string = language;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            Option<CpgGenerator> option = this.generatorFactory().forLanguage(language);
            if (None$.MODULE$.equals(option)) {
                throw new ConsoleException("No CPG generator exists for language: " + language);
            }
            if (option instanceof Some) {
                CpgGenerator frontend = (CpgGenerator)((Some)option).value();
                return this.io$joern$console$cpgcreation$ImportCode$$apply(frontend, inputPath, projectName);
            }
            throw new MatchError(option);
        }
        Option<CpgGenerator> option = this.generatorFactory().forCodeAt(inputPath);
        if (None$.MODULE$.equals(option)) {
            throw new ConsoleException("No suitable CPG generator found for: " + inputPath);
        }
        if (option instanceof Some) {
            CpgGenerator frontend = (CpgGenerator)((Some)option).value();
            return this.io$joern$console$cpgcreation$ImportCode$$apply(frontend, inputPath, projectName);
        }
        throw new MatchError(option);
    }

    public String apply$default$2() {
        return "";
    }

    public String apply$default$3() {
        return "";
    }

    public SourceBasedFrontend c() {
        return new CFrontend("c", this.CFrontend().$lessinit$greater$default$2());
    }

    public SourceBasedFrontend cpp() {
        return new CFrontend("cpp", "cpp");
    }

    public SourceBasedFrontend java() {
        return new SourceBasedFrontend(this, "java", "JAVASRC", "Java Source Frontend", "java");
    }

    public Frontend jvm() {
        return new BinaryFrontend("jvm", "JAVA", "Java/Dalvik Bytecode Frontend (based on SOOT's jimple)");
    }

    public Frontend ghidra() {
        return new BinaryFrontend("ghidra", "GHIDRA", "ghidra reverse engineering frontend");
    }

    public SourceBasedFrontend kotlin() {
        return new SourceBasedFrontend(this, "kotlin", "KOTLIN", "Kotlin Source Frontend", "kt");
    }

    public SourceBasedFrontend python() {
        return new SourceBasedFrontend(this, "python", "PYTHONSRC", "Python Source Frontend", "py");
    }

    public SourceBasedFrontend golang() {
        return new SourceBasedFrontend(this, "golang", "GOLANG", "Golang Source Frontend", "go");
    }

    public SourceBasedFrontend javascript() {
        return new JsFrontend("javascript", "JAVASCRIPT", "Javascript Source Frontend", "js");
    }

    public SourceBasedFrontend jssrc() {
        return new JsFrontend("jssrc", "JSSRC", "Javascript/Typescript Source Frontend based on astgen", "js");
    }

    public SourceBasedFrontend swiftsrc() {
        return new SwiftSrcFrontend("swiftsrc", "SWIFTSRC", "Swift Source Frontend based on swiftastgen", "swift");
    }

    public Frontend csharp() {
        return new BinaryFrontend("csharp", "CSHARP", "C# Source Frontend (Roslyn)");
    }

    public SourceBasedFrontend csharpsrc() {
        return new SourceBasedFrontend(this, "csharpsrc", "CSHARPSRC", "C# Source Frontend based on DotNetAstGen", "cs");
    }

    public Frontend llvm() {
        return new BinaryFrontend("llvm", "LLVM", "LLVM Bitcode Frontend");
    }

    public SourceBasedFrontend php() {
        return new SourceBasedFrontend(this, "php", "PHP", "PHP source frontend", "php");
    }

    public SourceBasedFrontend ruby() {
        return new SourceBasedFrontend(this, "ruby", "RUBYSRC", "Ruby source frontend", "rb");
    }

    private List<Frontend> allFrontends() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Frontend[]{this.c(), this.cpp(), this.ghidra(), this.kotlin(), this.java(), this.jvm(), this.javascript(), this.jssrc(), this.swiftsrc(), this.golang(), this.llvm(), this.php(), this.python(), this.csharp(), this.ruby(), this.csharpsrc()}));
    }

    public final ImportCode$Frontend$ Frontend() {
        return this.Frontend$lzy1;
    }

    private final ImportCode$BinaryFrontend$ BinaryFrontend() {
        return this.BinaryFrontend$lzy1;
    }

    public final ImportCode$CFrontend$ CFrontend() {
        return this.CFrontend$lzy1;
    }

    public Try<Cpg> io$joern$console$cpgcreation$ImportCode$$withCodeInTmpFile(String str, String filename, Function1<File, Cpg> f) {
        Option option = File$.MODULE$.newTemporaryDirectory$default$2();
        File dir = File$.MODULE$.newTemporaryDirectory("console", option, File$.MODULE$.newTemporaryDirectory$default$3("console", option));
        Try result = Try$.MODULE$.apply(() -> ImportCode.$anonfun$2(dir, filename, str, f));
        dir.deleteOnExit(true, dir.deleteOnExit$default$2());
        return result;
    }

    public Try<Cpg> io$joern$console$cpgcreation$ImportCode$$withFileInTmpFile(String inputPath, Function1<File, Cpg> f) {
        Option option = File$.MODULE$.newTemporaryDirectory$default$2();
        File dir = File$.MODULE$.newTemporaryDirectory("console", option, File$.MODULE$.newTemporaryDirectory$default$3("console", option));
        Try result = Try$.MODULE$.apply(() -> ImportCode.$anonfun$3(inputPath, dir, f));
        dir.deleteOnExit(true, dir.deleteOnExit$default$2());
        return result;
    }

    public String toString() {
        List cols = (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"description", (List)new .colon.colon((Object)"available", (List)Nil$.MODULE$)));
        List rows = this.allFrontends().map((Function1 & Serializable)frontend -> (List)new .colon.colon((Object)frontend.name(), (List)new .colon.colon((Object)frontend.description(), (List)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)frontend.isAvailable()).toString(), (List)Nil$.MODULE$))));
        return "Type `importCode.<language>` to run a specific language frontend\n\n" + Table$.MODULE$.apply((Seq)cols, (Seq)rows).render(this.io$joern$console$cpgcreation$ImportCode$$availableWidthProvider);
    }

    public Cpg io$joern$console$cpgcreation$ImportCode$$apply(CpgGenerator generator, String inputPath, String projectName) {
        this.io$joern$console$cpgcreation$ImportCode$$checkInputPath(inputPath);
        String name = (String)Option$.MODULE$.apply((Object)projectName).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).getOrElse(() -> this.$anonfun$6(inputPath));
        this.report("Creating project `" + name + "` for code at `" + inputPath + "`");
        Option cpgMaybe = this.workspace.createProject(inputPath, name).flatMap((Function1 & Serializable)pathToProject -> {
            Path frontendCpgOutFile = pathToProject.resolve(Console$.MODULE$.nameOfLegacyCpgInProject());
            Try<Path> try_ = this.generatorFactory().runGenerator(generator, inputPath, frontendCpgOutFile.toString());
            if (try_ instanceof Success) {
                return this.io$joern$console$cpgcreation$ImportCode$$console.open(name).flatMap((Function1 & Serializable)_$3 -> _$3.cpg());
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new ConsoleException("Error creating project for input path: `" + inputPath + "`", exception);
            }
            throw new MatchError(try_);
        });
        return (Cpg)cpgMaybe.map((Function1 & Serializable)cpg -> {
            this.report(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Code successfully imported. You can now query it using `cpg`.\n          |For an overview of all imported code, type `workspace`.")));
            this.io$joern$console$cpgcreation$ImportCode$$console.applyDefaultOverlays((Cpg)cpg);
            return generator.applyPostProcessingPasses((Cpg)cpg);
        }).getOrElse(() -> ImportCode.apply$$anonfun$2(inputPath));
    }

    public static final /* synthetic */ boolean io$joern$console$cpgcreation$ImportCode$Frontend$$_$isAvailable$$anonfun$1(CpgGenerator _$1) {
        return _$1.isAvailable();
    }

    private static final Cpg $anonfun$2(File dir$1, String filename$1, String str$1, Function1 f$1) {
        File file = dir$1.$div(filename$1);
        file.write(str$1, file.write$default$2(str$1), file.write$default$3(str$1));
        return (Cpg)f$1.apply((Object)dir$1);
    }

    private static final Cpg $anonfun$3(String inputPath$2, File dir$2, Function1 f$2) {
        File file = File$.MODULE$.apply(inputPath$2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        file.copyToDirectory(dir$2, file.copyToDirectory$default$2(dir$2), file.copyToDirectory$default$3(dir$2));
        return (Cpg)f$2.apply((Object)dir$2);
    }

    private final String $anonfun$6(String inputPath$3) {
        return Console$.MODULE$.deriveNameFromInputPath(inputPath$3, this.workspace);
    }

    private static final Cpg apply$$anonfun$2(String inputPath$5) {
        throw new ConsoleException("Error creating project for input path: `" + inputPath$5 + "`");
    }

    public class BinaryFrontend
    extends Frontend {
        public BinaryFrontend(String name, String language, String description) {
            if (ImportCode.this == null) {
                throw new NullPointerException();
            }
            super(ImportCode.this, name, language, description, ImportCode.this.io$joern$console$cpgcreation$ImportCode$$availableWidthProvider);
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$BinaryFrontend$$$outer() {
            return ImportCode.this;
        }
    }

    public class CFrontend
    extends SourceBasedFrontend {
        public CFrontend(String name, String extension) {
            if (ImportCode.this == null) {
                throw new NullPointerException();
            }
            super(ImportCode.this, name, "NEWC", "Eclipse CDT Based Frontend for C/C++", extension);
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$CFrontend$$$outer() {
            return ImportCode.this;
        }
    }

    public abstract class Frontend {
        private final String name;
        private final String language;
        private final String description;
        private final Table.AvailableWidthProvider availableWidthProvider;
        private final /* synthetic */ ImportCode $outer;

        public Frontend(ImportCode $outer, String name, String language, String description, Table.AvailableWidthProvider availableWidthProvider) {
            this.name = name;
            this.language = language;
            this.description = description;
            this.availableWidthProvider = availableWidthProvider;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String name() {
            return this.name;
        }

        public String language() {
            return this.language;
        }

        public String description() {
            return this.description;
        }

        public Option<CpgGenerator> cpgGeneratorForLanguage(String language, FrontendConfig config, Path rootPath, List<String> args) {
            return package$.MODULE$.cpgGeneratorForLanguage(language, config, rootPath, args);
        }

        public boolean isAvailable() {
            return this.cpgGeneratorForLanguage(this.language(), this.$outer.io$joern$console$cpgcreation$ImportCode$$config.frontend(), this.$outer.io$joern$console$cpgcreation$ImportCode$$config.install().rootPath().path(), (List<String>)scala.package$.MODULE$.Nil()).exists(ImportCode::io$joern$console$cpgcreation$ImportCode$Frontend$$_$isAvailable$$anonfun$1);
        }

        public Cpg fromFile(String inputPath, String projectName, List<String> args) {
            this.$outer.io$joern$console$cpgcreation$ImportCode$$checkInputPath(inputPath);
            File file = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (file.isDirectory(file.isDirectory$default$1())) {
                throw new ConsoleException("Input path is a directory: '" + inputPath + "'");
            }
            Try<Cpg> try_ = this.$outer.io$joern$console$cpgcreation$ImportCode$$withFileInTmpFile(inputPath, (Function1<File, Cpg>)(Function1 & Serializable)dir -> this.apply(dir.pathAsString(), projectName, args));
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new ConsoleException("unable to generate cpg from file '" + inputPath + "'", exception);
            }
            if (try_ instanceof Success) {
                Cpg value = (Cpg)((Success)try_).value();
                return value;
            }
            throw new MatchError(try_);
        }

        public String fromFile$default$2() {
            return "";
        }

        public List<String> fromFile$default$3() {
            return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }

        public Cpg apply(String inputPath, String projectName, List<String> args) {
            CpgGenerator frontend = (CpgGenerator)this.cpgGeneratorForLanguage(this.language(), this.$outer.io$joern$console$cpgcreation$ImportCode$$config.frontend(), this.$outer.io$joern$console$cpgcreation$ImportCode$$config.install().rootPath().path(), args).getOrElse(this::$anonfun$1);
            return new ImportCode(this.$outer.io$joern$console$cpgcreation$ImportCode$$console, this.availableWidthProvider).io$joern$console$cpgcreation$ImportCode$$apply(frontend, inputPath, projectName);
        }

        public String apply$default$2() {
            return "";
        }

        public List<String> apply$default$3() {
            return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$Frontend$$$outer() {
            return this.$outer;
        }

        private final CpgGenerator $anonfun$1() {
            throw new ConsoleException("no cpg generator for language=" + this.language() + " available!");
        }
    }

    public class JsFrontend
    extends SourceBasedFrontend {
        public JsFrontend(String name, String language, String description, String extension) {
            if (ImportCode.this == null) {
                throw new NullPointerException();
            }
            super(ImportCode.this, name, language, description, extension);
        }

        @Override
        public Cpg apply(String inputPath, String projectName, List<String> args) {
            File file = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (!file.isDirectory(file.isDirectory$default$1())) {
                return super.fromFile(inputPath, projectName, args);
            }
            return super.apply(inputPath, projectName, args);
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$JsFrontend$$$outer() {
            return ImportCode.this;
        }
    }

    public class SourceBasedFrontend
    extends Frontend {
        private final String extension;
        private final /* synthetic */ ImportCode $outer;

        public SourceBasedFrontend(ImportCode $outer, String name, String language, String description, String extension) {
            this.extension = extension;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, name, language, description, $outer.io$joern$console$cpgcreation$ImportCode$$availableWidthProvider);
        }

        public Cpg fromString(String str, List<String> args) {
            Try<Cpg> try_ = this.$outer.io$joern$console$cpgcreation$ImportCode$$withCodeInTmpFile(str, "tmp." + this.extension, (Function1<File, Cpg>)(Function1 & Serializable)dir -> {
                String string = dir.pathAsString();
                String string2 = super.apply$default$2();
                return super.apply(string, string2, args);
            });
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new ConsoleException("unable to generate cpg from given String", exception);
            }
            if (try_ instanceof Success) {
                Cpg value = (Cpg)((Success)try_).value();
                return value;
            }
            throw new MatchError(try_);
        }

        public List<String> fromString$default$2() {
            return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$SourceBasedFrontend$$$outer() {
            return this.$outer;
        }
    }

    public class SwiftSrcFrontend
    extends SourceBasedFrontend {
        public SwiftSrcFrontend(String name, String language, String description, String extension) {
            if (ImportCode.this == null) {
                throw new NullPointerException();
            }
            super(ImportCode.this, name, language, description, extension);
        }

        @Override
        public Cpg apply(String inputPath, String projectName, List<String> args) {
            File file = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (!file.isDirectory(file.isDirectory$default$1())) {
                return super.fromFile(inputPath, projectName, args);
            }
            return super.apply(inputPath, projectName, args);
        }

        public final /* synthetic */ ImportCode io$joern$console$cpgcreation$ImportCode$SwiftSrcFrontend$$$outer() {
            return ImportCode.this;
        }
    }
}

