/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.workspacehandling;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import flatgraph.help.Table;
import io.joern.console.workspacehandling.Project;
import io.joern.console.workspacehandling.ProjectFile;
import io.joern.console.workspacehandling.ProjectFile$;
import io.joern.console.workspacehandling.Workspace;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Readable$;
import ujson.Value;

public abstract class WorkspaceLoader<ProjectType extends Project> {
    private final Table.AvailableWidthProvider availableWidthProvider;
    private final String PROJECTFILE_NAME;

    public WorkspaceLoader(Table.AvailableWidthProvider availableWidthProvider) {
        this.availableWidthProvider = availableWidthProvider;
        this.PROJECTFILE_NAME = "project.json";
    }

    public Workspace<ProjectType> load(String path) {
        File dirFile = File$.MODULE$.apply(path, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Path dirPath = dirFile.path().toAbsolutePath();
        Dsl$.MODULE$.mkdirs(dirFile);
        return new Workspace(ListBuffer$.MODULE$.from(this.loadProjectsFromFs(dirPath)), this.availableWidthProvider);
    }

    private LazyList<ProjectType> loadProjectsFromFs(Path cpgsPath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cpgsPath.toFile().listFiles());
        return ((LazyList)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.isDirectory())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).flatMap((Function1 & Serializable)f -> this.loadProject(f.toPath()));
    }

    public Option<ProjectType> loadProject(Path path) {
        Try try_ = Try$.MODULE$.apply(() -> this.loadProject$$anonfun$1(path));
        if (try_ instanceof Success) {
            Project v = (Project)((Success)try_).value();
            return Some$.MODULE$.apply((Object)v);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            System.err.println("Error loading project at " + path + " - skipping: ");
            e.printStackTrace();
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public abstract ProjectType createProject(ProjectFile var1, Path var2);

    private ProjectFile readProjectFile(Path projectDirName) {
        Value data = ujson.package$.MODULE$.read(Readable$.MODULE$.fromPath(projectDirName.resolve(this.PROJECTFILE_NAME)), ujson.package$.MODULE$.read$default$2());
        return ProjectFile$.MODULE$.apply(data.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector("inputPath")).str(), data.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector("name")).str());
    }

    private final Project loadProject$$anonfun$1(Path path$1) {
        ProjectFile projectFile = this.readProjectFile(path$1);
        return this.createProject(projectFile, path$1);
    }
}

