/*
 * Decompiled with CFR 0.152.
 */
package io.joern.console.workspacehandling;

import better.files.Dsl$;
import better.files.File$;
import better.files.package$;
import io.joern.console.Error;
import io.joern.console.Reporting;
import io.joern.console.workspacehandling.DefaultLoader$;
import io.joern.console.workspacehandling.Project;
import io.joern.console.workspacehandling.Project$;
import io.joern.console.workspacehandling.ProjectFile;
import io.joern.console.workspacehandling.ProjectFile$;
import io.joern.console.workspacehandling.Workspace;
import io.joern.console.workspacehandling.WorkspaceLoader;
import io.joern.console.workspacehandling.WorkspaceManager$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.File;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.file.Path;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.native.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class WorkspaceManager<ProjectType extends Project>
implements Reporting {
    private final String path;
    private final WorkspaceLoader<ProjectType> loader;
    private Workspace<ProjectType> workspace;
    private final Path dirPath;
    private final String LEGACY_BASE_CPG_FILENAME;
    private final String OVERLAY_DIR_NAME;

    public static List<better.files.File> overlayFilesForDir(String string) {
        return WorkspaceManager$.MODULE$.overlayFilesForDir(string);
    }

    public static <ProjectType extends Project> DefaultLoader$ $lessinit$greater$default$2() {
        return WorkspaceManager$.MODULE$.$lessinit$greater$default$2();
    }

    public WorkspaceManager(String path, WorkspaceLoader<ProjectType> loader) {
        this.path = path;
        this.loader = loader;
        this.workspace = loader.load(path);
        this.dirPath = File$.MODULE$.apply(path, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath();
        this.LEGACY_BASE_CPG_FILENAME = "cpg.bin.zip";
        this.OVERLAY_DIR_NAME = "overlays";
    }

    public String getPath() {
        return this.path;
    }

    public Option<Path> createProject(String inputPath, String projectName) {
        return Some$.MODULE$.apply((Object)File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).filter((Function1 & Serializable)_$1 -> _$1.exists(_$1.exists$default$1())).map((Function1 & Serializable)_$2 -> {
            Path pathToProject = this.projectNameToDir(projectName);
            if (this.project(projectName).isDefined()) {
                System.err.println("Project with name " + projectName + " already exists - overwriting");
                this.removeProject(projectName);
            }
            this.createProjectDirectory(inputPath, projectName);
            this.loader.loadProject(pathToProject).foreach((Function1 & Serializable)project -> this.addProjectToProjectsList(project));
            return pathToProject;
        });
    }

    public void removeProject(String name) {
        this.closeProject(name);
        this.removeProjectFromList(name);
        better.files.File file = File$.MODULE$.apply(this.projectNameToDir(name));
        file.delete(file.delete$default$1(), file.delete$default$2());
    }

    private void createProjectDirectory(String inputPath, String name) {
        Path dirPath = this.projectNameToDir(name);
        Dsl$.MODULE$.mkdirs(File$.MODULE$.apply(dirPath));
        String absoluteInputPath = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().toString();
        Dsl$.MODULE$.mkdirs(File$.MODULE$.apply(this.overlayDir(name), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
        ProjectFile projectFile = ProjectFile$.MODULE$.apply(absoluteInputPath, name);
        this.writeProjectFile(projectFile, dirPath);
        Dsl$.MODULE$.touch(package$.MODULE$.StringExtensions(dirPath.toString()).$div("cpg.bin"));
    }

    private better.files.File writeProjectFile(ProjectFile projectFile, Path dirPath) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        String PROJECTFILE_NAME = "project.json";
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"inputPath");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)projectFile.inputPath());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)projectFile.name());
        String content = Serialization$.MODULE$.write(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Formats)formats);
        better.files.File file = File$.MODULE$.apply(dirPath.resolve(PROJECTFILE_NAME));
        return file.write(content, file.write$default$2(content), file.write$default$3(content));
    }

    public void reset() {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.reset$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.deleteWorkspace();
        this.workspace = this.loader.load(this.path);
    }

    private void deleteWorkspace() {
        block5: {
            block4: {
                if (this.dirPath == null) break block4;
                String string = this.dirPath.toString();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block5;
            }
            throw new Error("dirPath is not set");
        }
        better.files.File dirFile = File$.MODULE$.apply(this.dirPath.toAbsolutePath().toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!dirFile.exists(dirFile.exists$default$1())) {
            throw new Error("Directory " + dirFile.toString() + " does not exist");
        }
        dirFile.delete(dirFile.delete$default$1(), dirFile.delete$default$2());
    }

    public int numberOfProjects() {
        return this.workspace.projects().size();
    }

    public List<Project> projects() {
        return this.workspace.projects().toList();
    }

    public Option<Project> project(String name) {
        return this.workspace.projects().find((Function1 & Serializable)_$3 -> {
            String string = _$3.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public String toString() {
        return this.workspace.toString();
    }

    private Option<Project> getProjectByPath(Path projectPath) {
        return this.workspace.projects().find((Function1 & Serializable)_$4 -> {
            Path path = _$4.path().toAbsolutePath();
            Path path2 = projectPath.toAbsolutePath();
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        });
    }

    public List<Cpg> loadedCpgs() {
        return ((ListBuffer)this.workspace.projects().flatMap((Function1 & Serializable)_$5 -> _$5.cpg())).toList();
    }

    public boolean projectExists(String inputPath) {
        return this.projectDir(inputPath).toFile().exists();
    }

    public boolean cpgExists(String inputPath, boolean isLegacy) {
        String baseFileName = isLegacy ? this.LEGACY_BASE_CPG_FILENAME : WorkspaceManager$.io$joern$console$workspacehandling$WorkspaceManager$$$BASE_CPG_FILENAME;
        return this.projectExists(inputPath) && this.projectDir(inputPath).resolve(baseFileName).toFile().exists();
    }

    public boolean cpgExists$default$2() {
        return false;
    }

    public String overlayDir(String inputPath) {
        return this.projectDir(inputPath).resolve(this.OVERLAY_DIR_NAME).toString();
    }

    public String overlayDirByProjectName(String name) {
        return this.projectNameToDir(name).resolve(this.OVERLAY_DIR_NAME).toString();
    }

    private String baseCpgFilename(String inputPath, boolean isLegacy) {
        String baseFileName = isLegacy ? this.LEGACY_BASE_CPG_FILENAME : WorkspaceManager$.io$joern$console$workspacehandling$WorkspaceManager$$$BASE_CPG_FILENAME;
        return this.projectDir(inputPath).resolve(baseFileName).toString();
    }

    private boolean baseCpgFilename$default$2() {
        return false;
    }

    private Path projectDir(String inputPath) {
        Path filename = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().getFileName();
        if (filename == null) {
            throw new RuntimeException("invalid input path: " + inputPath);
        }
        return this.dirPath.resolve(URLEncoder.encode(filename.toString(), package$.MODULE$.DefaultCharset().toString())).toAbsolutePath();
    }

    private Path projectNameToDir(String name) {
        return this.dirPath.resolve(URLEncoder.encode(name, package$.MODULE$.DefaultCharset().toString())).toAbsolutePath();
    }

    private Option<ProjectType> projectByName(String name) {
        return this.workspace.projects().find((Function1 & Serializable)r -> {
            String string = r.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<ProjectType> projectByCpg(Cpg baseCpg) {
        return this.workspace.projects().find((Function1 & Serializable)_$6 -> _$6.cpg().contains((Object)baseCpg));
    }

    public boolean projectExistsForCpg(Cpg baseCpg) {
        return this.projectByCpg(baseCpg).isDefined();
    }

    public String getNextOverlayDirName(Cpg baseCpg, String overlayName) {
        Project project = (Project)this.projectByCpg(baseCpg).get();
        better.files.File overlayDirectory = File$.MODULE$.apply(this.overlayDirByProjectName(project.name()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        File overlayFile = overlayDirectory.path().resolve(overlayName).toFile();
        return overlayFile.getAbsolutePath();
    }

    public Cpg cpg() {
        Option option = this.workspace.projects().lastOption();
        if (option instanceof Some) {
            Project project = (Project)((Some)option).value();
            return (Cpg)project.cpg().getOrElse(() -> WorkspaceManager.cpg$$anonfun$1(project));
        }
        if (None$.MODULE$.equals(option)) {
            throw new Error("No projects loaded");
        }
        throw new MatchError((Object)option);
    }

    public Option<ProjectType> setActiveProject(String name) {
        Option<ProjectType> project = this.projectByName(name);
        if (project.isEmpty()) {
            System.err.println("Error: project with name " + name + " does not exist");
            return None$.MODULE$;
        }
        return this.removeProjectFromList(name).map((Function1 & Serializable)p -> {
            this.addProjectToProjectsList(p);
            return p;
        });
    }

    public Option<Project> getActiveProject() {
        return this.workspace.projects().lastOption();
    }

    public Option<Project> openProject(String name, Function1<String, Option<Cpg>> loader) {
        if (!this.projectExists(name)) {
            this.report("Project does not exist in workspace. Try `importCode/importCpg(inputPath)` to create it");
            return None$.MODULE$;
        }
        better.files.File file = File$.MODULE$.apply(this.baseCpgFilename(name, this.baseCpgFilename$default$2()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!file.exists(file.exists$default$1())) {
            this.report("CPG for project " + name + " does not exist at " + this.baseCpgFilename(name, this.baseCpgFilename$default$2()) + ", bailing out");
            return None$.MODULE$;
        }
        if (this.project(name).exists((Function1 & Serializable)_$7 -> _$7.cpg().isDefined())) {
            this.setActiveProject(name);
            return this.project(name);
        }
        String cpgFilename = this.baseCpgFilename(name, this.baseCpgFilename$default$2());
        this.report("Creating working copy of CPG to be safe");
        better.files.File cpgFile = File$.MODULE$.apply(cpgFilename, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Path workingCopyPath = this.projectDir(name).resolve(Project$.MODULE$.workCpgFileName());
        String workingCopyName = workingCopyPath.toAbsolutePath().toString();
        Dsl$.MODULE$.cp(cpgFile, File$.MODULE$.apply(workingCopyPath));
        this.report("Loading base CPG from: " + workingCopyName);
        Option newCpg = (Option)loader.apply((Object)workingCopyName);
        Path projectPath = File$.MODULE$.apply(workingCopyName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).parent().path();
        Option result = newCpg.flatMap((Function1 & Serializable)c -> {
            this.unloadCpgIfExists(name);
            this.setCpgForProject((Cpg)c, projectPath);
            return this.projectByCpg((Cpg)c);
        });
        return result;
    }

    public Function1<String, Option<Cpg>> openProject$default$2() {
        return (Function1 & Serializable)x -> this.loadCpgRaw((String)x);
    }

    public Option<Project> closeProject(String name) {
        return this.projectByName(name).map((Function1 & Serializable)_$8 -> _$8.close());
    }

    private void setCpgForProject(Cpg newCpg, Path projectPath) {
        Option<Project> project = this.getProjectByPath(projectPath);
        Option<Project> option = project;
        if (option instanceof Some) {
            Project p = (Project)((Some)option).value();
            p.cpg_$eq((Option<Cpg>)Some$.MODULE$.apply((Object)newCpg));
            this.setActiveProject(p.name());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            System.err.println("Error setting CPG for non-existing/unloaded project at " + projectPath);
            return;
        }
        throw new MatchError(option);
    }

    private Option<Cpg> loadCpgRaw(String cpgFilename) {
        Try try_ = Try$.MODULE$.apply(() -> WorkspaceManager.loadCpgRaw$$anonfun$1(cpgFilename));
        if (try_ instanceof Success) {
            Cpg v = (Cpg)((Success)try_).value();
            return Some$.MODULE$.apply((Object)v);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            System.err.println("Error loading CPG");
            ex.printStackTrace();
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private ListBuffer<ProjectType> addProjectToProjectsList(ProjectType project) {
        return (ListBuffer)this.workspace.projects().$plus$eq(project);
    }

    public void unloadCpgByProjectName(String name) {
        this.projectByName(name).foreach((Function1)(JProcedure1 & Serializable)record -> {
            record.cpg().foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.close());
            record.cpg_$eq((Option<Cpg>)None$.MODULE$);
        });
    }

    public Option<Cpg> reloadCpgByName(String name, Function1<String, Option<Cpg>> loadCpg) {
        return this.projectByName(name).flatMap((Function1 & Serializable)record -> {
            record.cpg_$eq((Option<Cpg>)((Option)loadCpg.apply((Object)record.name())));
            return record.cpg();
        });
    }

    private void unloadCpgIfExists(String name) {
        this.projectByName(File$.MODULE$.apply(this.projectDir(name)).name()).flatMap((Function1 & Serializable)_$10 -> _$10.cpg()).foreach((Function1)(JProcedure1 & Serializable)c -> {
            try {
                c.close();
            }
            catch (IllegalStateException illegalStateException) {}
        });
    }

    public void deleteCurrentProject() {
        Option<ProjectType> project = this.projectByCpg(this.cpg());
        Option<ProjectType> option = project;
        if (option instanceof Some) {
            Project p = (Project)((Some)option).value();
            this.deleteProject(p);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.report("Project for active CPG does not exist");
            return;
        }
        throw new MatchError(option);
    }

    public Option<BoxedUnit> deleteProject(String name) {
        Option<ProjectType> project = this.projectByName(name);
        Option<ProjectType> option = project;
        if (option instanceof Some) {
            Project p = (Project)((Some)option).value();
            this.deleteProject(p);
            return Option$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }
        if (None$.MODULE$.equals(option)) {
            this.report("Project with name " + name + " does not exist");
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private void deleteProject(Project project) {
        this.removeProjectFromList(project.name());
        String string = project.path().toString();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            better.files.File file = File$.MODULE$.apply(project.path());
            file.delete(file.delete$default$1(), file.delete$default$2());
            return;
        }
    }

    private Option<ProjectType> removeProjectFromList(String name) {
        return ((IterableOnceOps)this.workspace.projects().zipWithIndex()).find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Project record = (Project)tuple2._1();
                String string = record.name();
                String string2 = name;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)_$11 -> BoxesRunTime.unboxToInt((Object)_$11._2())).map((Function1 & Serializable)index -> this.removeProjectFromList$$anonfun$3(BoxesRunTime.unboxToInt((Object)index)));
    }

    public boolean recordExists(String inputPath) {
        return this.projectExists(inputPath);
    }

    public boolean baseCpgExists(String inputPath, boolean isLegacy) {
        return this.cpgExists(inputPath, isLegacy);
    }

    public boolean baseCpgExists$default$2() {
        return false;
    }

    private final void reset$$anonfun$1() {
        this.cpg().close();
    }

    private static final Cpg cpg$$anonfun$1(Project project$1) {
        throw new Error("No CPG loaded for project " + project$1.name() + " - try e.g. `help|importCode|importCpg|open`");
    }

    private static final Cpg loadCpgRaw$$anonfun$1(String cpgFilename$1) {
        return CpgLoader$.MODULE$.load(cpgFilename$1);
    }

    private final /* synthetic */ Project removeProjectFromList$$anonfun$3(int index) {
        return (Project)this.workspace.projects().remove(index);
    }
}

