/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.passes.reachingdef;

import io.joern.dataflowengineoss.passes.reachingdef.DataFlowProblem;
import io.joern.dataflowengineoss.passes.reachingdef.DataFlowSolver;
import io.joern.dataflowengineoss.passes.reachingdef.DdgGenerator;
import io.joern.dataflowengineoss.passes.reachingdef.ReachingDefPass$;
import io.joern.dataflowengineoss.passes.reachingdef.ReachingDefProblem$;
import io.joern.dataflowengineoss.passes.reachingdef.ReachingDefTransferFunction;
import io.joern.dataflowengineoss.passes.reachingdef.Solution;
import io.joern.dataflowengineoss.semanticsloader.Semantics;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import io.shiftleft.semanticcpg.language.package$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import scala.Function2;
import scala.Tuple2;
import scala.collection.BitSetOps;
import scala.collection.mutable.BitSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class ReachingDefPass
extends ForkJoinParallelCpgPass<Method> {
    private final Cpg cpg;
    private final int maxNumberOfDefinitions;
    private final Semantics s;
    private final Logger logger;

    public static int $lessinit$greater$default$2() {
        return ReachingDefPass$.MODULE$.$lessinit$greater$default$2();
    }

    public ReachingDefPass(Cpg cpg, int maxNumberOfDefinitions, Semantics s) {
        this.cpg = cpg;
        this.maxNumberOfDefinitions = maxNumberOfDefinitions;
        this.s = s;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2(), ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        s.loadRegexSemantics(cpg);
    }

    public Method[] generateParts() {
        return (Method[])package$.MODULE$.toNodeTypeStarters(this.cpg).method().toArray(ClassTag$.MODULE$.apply(Method.class));
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder dstGraph, Method method) {
        this.logger.info("Calculating reaching definitions for: {} in {}", (Object)method.fullName(), (Object)method.filename());
        DataFlowProblem<StoredNode, BitSet> problem = ReachingDefProblem$.MODULE$.create(method);
        if (this.shouldBailOut(method, problem)) {
            this.logger.warn("Skipping.");
            return;
        }
        Solution<StoredNode, BitSet> solution = new DataFlowSolver().calculateMopSolutionForwards(problem);
        DdgGenerator ddgGenerator = new DdgGenerator(this.s);
        ddgGenerator.addReachingDefEdges(dstGraph, method, problem, solution);
    }

    private boolean shouldBailOut(Method method, DataFlowProblem<StoredNode, BitSet> problem) {
        ReachingDefTransferFunction transferFunction = (ReachingDefTransferFunction)problem.transferFunction();
        int numberOfDefinitions = BoxesRunTime.unboxToInt((Object)transferFunction.gen().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(_$1, _$2) -> ReachingDefPass.$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1), (Tuple2)_$2)));
        this.logger.info("Number of definitions for {}: {}", (Object)method.fullName(), (Object)BoxesRunTime.boxToInteger((int)numberOfDefinitions));
        if (numberOfDefinitions > this.maxNumberOfDefinitions) {
            this.logger.warn("{} has more than {} definitions", (Object)method.fullName(), (Object)BoxesRunTime.boxToInteger((int)this.maxNumberOfDefinitions));
            return true;
        }
        return false;
    }

    private static final /* synthetic */ int $anonfun$1(int _$1, Tuple2 _$2) {
        return _$1 + ((BitSetOps)_$2._2()).size();
    }
}

