/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.semanticsloader;

import io.joern.dataflowengineoss.semanticsloader.FlowMapping;
import io.joern.dataflowengineoss.semanticsloader.FlowMapping$;
import io.joern.dataflowengineoss.semanticsloader.FlowNode;
import io.joern.dataflowengineoss.semanticsloader.FlowPath;
import io.joern.dataflowengineoss.semanticsloader.FlowSemantic;
import io.joern.dataflowengineoss.semanticsloader.Semantics$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.semanticcpg.language.package$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.runtime.function.JProcedure1;

public class Semantics {
    private final Map<String, FlowSemantic> methodToSemantic;
    private final HashMap<String, String> regexMatchedFullNames;

    public static Semantics empty() {
        return Semantics$.MODULE$.empty();
    }

    public static Semantics fromList(List<FlowSemantic> list) {
        return Semantics$.MODULE$.fromList(list);
    }

    public Semantics(Map<String, FlowSemantic> methodToSemantic) {
        this.methodToSemantic = methodToSemantic;
        this.regexMatchedFullNames = HashMap$.MODULE$.empty();
    }

    public void loadRegexSemantics(Cpg cpg) {
        ((IterableOnceOps)this.methodToSemantic.filter((Function1 & Serializable)_$1 -> ((FlowSemantic)_$1._2()).regex())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String regexString = (String)tuple2._1();
                Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(cpg).method());
                Iterator iterator2 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator, regexString));
                MethodTraversalExtGen$.MODULE$.fullName$extension(iterator2).foreach((Function1 & Serializable)methodMatch -> this.regexMatchedFullNames.put(methodMatch, (Object)regexString));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public List<FlowSemantic> elements() {
        return this.methodToSemantic.values().toList();
    }

    public Option<FlowSemantic> forMethod(String fullName) {
        Option option = this.regexMatchedFullNames.get((Object)fullName);
        if (option instanceof Some) {
            String matchedFullName = (String)((Some)option).value();
            return this.methodToSemantic.get((Object)matchedFullName);
        }
        if (None$.MODULE$.equals(option)) {
            return this.methodToSemantic.get((Object)fullName);
        }
        throw new MatchError((Object)option);
    }

    public String serialize() {
        return ((List)this.elements().sortBy((Function1 & Serializable)_$2 -> _$2.methodFullName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)elem -> "\"" + elem.methodFullName() + "\" " + elem.mappings().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(FlowPath x) {
                FlowPath flowPath = x;
                if (flowPath instanceof FlowMapping) {
                    FlowMapping flowMapping = FlowMapping$.MODULE$.unapply((FlowMapping)flowPath);
                    FlowNode flowNode = flowMapping._1();
                    FlowNode flowNode2 = flowMapping._2();
                    FlowNode x2 = flowNode;
                    FlowNode y = flowNode2;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(FlowPath x, Function1 function1) {
                FlowPath flowPath = x;
                if (flowPath instanceof FlowMapping) {
                    FlowMapping flowMapping = FlowMapping$.MODULE$.unapply((FlowMapping)flowPath);
                    FlowNode flowNode = flowMapping._1();
                    FlowNode flowNode2 = flowMapping._2();
                    FlowNode x2 = flowNode;
                    FlowNode y = flowNode2;
                    return x2 + " -> " + y;
                }
                return function1.apply((Object)x);
            }
        }).mkString(" ")).mkString("\n");
    }
}

