/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.passes.reachingdef;

import flatgraph.traversal.GenericSteps$;
import io.joern.dataflowengineoss.passes.reachingdef.DataFlowProblem;
import io.joern.dataflowengineoss.passes.reachingdef.ReachingDefFlowGraph;
import io.joern.dataflowengineoss.queryengine.AccessPathUsage$;
import io.shiftleft.codepropertygraph.generated.accessors.Accessors;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.FieldIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.Identifier;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.Return;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.semanticcpg.accesspath.AccessPath;
import io.shiftleft.semanticcpg.accesspath.MatchResult$;
import io.shiftleft.semanticcpg.accesspath.TrackedBase;
import io.shiftleft.semanticcpg.language.nodemethods.AstNodeMethods$;
import io.shiftleft.semanticcpg.language.nodemethods.CallMethods$;
import io.shiftleft.semanticcpg.language.package$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.BitSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class UsageAnalyzer {
    private final Map<StoredNode, Set<Object>> in;
    private final Map<Object, StoredNode> numberToNode;
    private final List<StoredNode> allNodes;
    private final Set<String> containerSet;
    private final Set<String> indirectionAccessSet;
    private final Map<StoredNode, Map<StoredNode, Set<Object>>> usedIncomingDefs;

    public UsageAnalyzer(DataFlowProblem<StoredNode, BitSet> problem, Map<StoredNode, Set<Object>> in) {
        this.in = in;
        this.numberToNode = ((ReachingDefFlowGraph)problem.flowGraph()).numberToNode();
        this.allNodes = in.keys().toList();
        this.containerSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<operator>.fieldAccess", "<operator>.indexAccess", "<operator>.indirectIndexAccess", "<operator>.indirectFieldAccess"}));
        this.indirectionAccessSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<operator>.addressOf", "<operator>.indirection"}));
        this.usedIncomingDefs = this.initUsedIncomingDefs();
    }

    public Map<Object, StoredNode> numberToNode() {
        return this.numberToNode;
    }

    public Map<StoredNode, Map<StoredNode, Set<Object>>> usedIncomingDefs() {
        return this.usedIncomingDefs;
    }

    public Map<StoredNode, Map<StoredNode, Set<Object>>> initUsedIncomingDefs() {
        return this.allNodes.map((Function1 & Serializable)node -> {
            StoredNode storedNode = (StoredNode)Predef$.MODULE$.ArrowAssoc(node);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)storedNode, this.usedIncomingDefsForNode((StoredNode)node));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<StoredNode, Set<Object>> usedIncomingDefsForNode(StoredNode node) {
        return ((IterableOnceOps)this.uses(node).map((Function1 & Serializable)use -> {
            StoredNode storedNode = (StoredNode)Predef$.MODULE$.ArrowAssoc(use);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)storedNode, ((IterableOps)this.in.apply((Object)node)).filter((Function1)(JFunction1.mcZI.sp & Serializable)inElement -> {
                StoredNode inElemNode = (StoredNode)this.numberToNode().apply((Object)BoxesRunTime.boxToInteger((int)inElement));
                return this.isUsing((StoredNode)use, inElemNode);
            }));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean isUsing(StoredNode use, StoredNode inElemNode) {
        return this.sameVariable(use, inElemNode) || this.isContainer(use, inElemNode) || this.isPart(use, inElemNode) || this.isAlias(use, inElemNode);
    }

    private boolean isContainer(StoredNode use, StoredNode inElement) {
        Call call;
        StoredNode storedNode = inElement;
        if (storedNode instanceof Call && this.containerSet.contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)(call = (Call)storedNode))))) {
            Iterator iterator = package$.MODULE$.iterableToGenericSteps((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
            return GenericSteps$.MODULE$.headOption$extension(iterator).exists((Function1 & Serializable)base -> {
                Option<String> option = this.nodeToString(use);
                Option<String> option2 = this.nodeToString((StoredNode)base);
                return !(option != null ? !option.equals(option2) : option2 != null);
            });
        }
        return false;
    }

    private boolean isPart(StoredNode use, StoredNode inElement) {
        Call call;
        StoredNode storedNode = use;
        if (storedNode instanceof Call && this.containerSet.contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)(call = (Call)storedNode))))) {
            StoredNode storedNode2 = inElement;
            if (storedNode2 instanceof MethodParameterIn) {
                MethodParameterIn param = (MethodParameterIn)storedNode2;
                Iterator iterator = package$.MODULE$.iterableToGenericSteps((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
                return GenericSteps$.MODULE$.headOption$extension(iterator).exists((Function1 & Serializable)base -> this.nodeToString((StoredNode)base).contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)param))));
            }
            if (storedNode2 instanceof Identifier) {
                Identifier identifier = (Identifier)storedNode2;
                Iterator iterator = package$.MODULE$.iterableToGenericSteps((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
                return GenericSteps$.MODULE$.headOption$extension(iterator).exists((Function1 & Serializable)base -> this.nodeToString((StoredNode)base).contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)identifier))));
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAlias(StoredNode use, StoredNode inElement) {
        StoredNode storedNode = use;
        if (!(storedNode instanceof Call)) return false;
        Call useCall = (Call)storedNode;
        StoredNode storedNode2 = inElement;
        if (!(storedNode2 instanceof Call)) return false;
        Call inCall = (Call)storedNode2;
        Tuple2<TrackedBase, AccessPath> tuple2 = AccessPathUsage$.MODULE$.toTrackedBaseAndAccessPathSimple((StoredNode)useCall);
        if (tuple2 == null) throw new MatchError(tuple2);
        TrackedBase useBase = (TrackedBase)tuple2._1();
        AccessPath useAccessPath = (AccessPath)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)useBase, (Object)useAccessPath);
        TrackedBase useBase2 = (TrackedBase)tuple22._1();
        AccessPath useAccessPath2 = (AccessPath)tuple22._2();
        Tuple2<TrackedBase, AccessPath> tuple23 = AccessPathUsage$.MODULE$.toTrackedBaseAndAccessPathSimple((StoredNode)inCall);
        if (tuple23 == null) throw new MatchError(tuple23);
        TrackedBase inBase = (TrackedBase)tuple23._1();
        AccessPath inAccessPath = (AccessPath)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)inBase, (Object)inAccessPath);
        TrackedBase inBase2 = (TrackedBase)tuple24._1();
        AccessPath inAccessPath2 = (AccessPath)tuple24._2();
        TrackedBase trackedBase = useBase2;
        TrackedBase trackedBase2 = inBase2;
        if (trackedBase == null) {
            if (trackedBase2 != null) {
                return false;
            }
        } else if (!trackedBase.equals(trackedBase2)) return false;
        Object object = useAccessPath2.matchAndDiff(inAccessPath2.elements())._1();
        Enumeration.Value value = MatchResult$.MODULE$.EXACT_MATCH();
        if (object == null) {
            if (value == null) return true;
            return false;
        } else {
            if (!object.equals(value)) return false;
            return true;
        }
    }

    public Set<StoredNode> uses(StoredNode node) {
        scala.collection.immutable.Set set;
        StoredNode storedNode = node;
        if (storedNode instanceof Return) {
            Return ret = (Return)storedNode;
            set = AstNodeMethods$.MODULE$.astChildren$extension(package$.MODULE$.cfgNodeToAstNode((CfgNode)ret)).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(AstNode x) {
                    AstNode astNode = x;
                    if (astNode instanceof Expression) {
                        Expression x2 = (Expression)astNode;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(AstNode x, Function1 function1) {
                    AstNode astNode = x;
                    if (astNode instanceof Expression) {
                        Expression x2 = (Expression)astNode;
                        return x2;
                    }
                    return function1.apply((Object)x);
                }
            }).toSet();
        } else if (storedNode instanceof Call) {
            Call call = (Call)storedNode;
            set = CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)).toSet();
        } else if (storedNode instanceof MethodParameterOut) {
            MethodParameterOut paramOut = (MethodParameterOut)storedNode;
            set = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StoredNode[]{paramOut}));
        } else {
            set = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StoredNode[0]));
        }
        scala.collection.immutable.Set n = set;
        return (Set)n.filterNot((Function1 & Serializable)_$3 -> _$3 instanceof FieldIdentifier);
    }

    private boolean sameVariable(StoredNode use, StoredNode inElement) {
        StoredNode storedNode = inElement;
        if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn param = (MethodParameterIn)storedNode;
            return this.nodeToString(use).contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)param)));
        }
        if (storedNode instanceof Call) {
            Call call = (Call)storedNode;
            Call call2 = call;
            if (this.indirectionAccessSet.contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)call2)))) {
                return CallMethods$.MODULE$.argumentOption$extension(package$.MODULE$.toCallMethods(call2), 1).exists((Function1 & Serializable)x -> this.nodeToString(use).contains((Object)Accessors.AccessPropertyCode$.MODULE$.code$extension(package$.MODULE$.accessPropertyCode((StoredNode)x))));
            }
            Call call3 = call;
            return this.nodeToString(use).contains((Object)Accessors.AccessPropertyCode$.MODULE$.code$extension(package$.MODULE$.accessPropertyCode((StoredNode)call3)));
        }
        if (storedNode instanceof Identifier) {
            Identifier identifier = (Identifier)storedNode;
            return this.nodeToString(use).contains((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)identifier)));
        }
        return false;
    }

    private Option<String> nodeToString(StoredNode node) {
        StoredNode storedNode = node;
        if (storedNode instanceof Identifier) {
            Identifier ident = (Identifier)storedNode;
            return Some$.MODULE$.apply((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)ident)));
        }
        if (storedNode instanceof Expression) {
            Expression exp = (Expression)storedNode;
            return Some$.MODULE$.apply((Object)Accessors.AccessPropertyCode$.MODULE$.code$extension(package$.MODULE$.accessPropertyCode((StoredNode)exp)));
        }
        if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn p = (MethodParameterIn)storedNode;
            return Some$.MODULE$.apply((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)p)));
        }
        if (storedNode instanceof MethodParameterOut) {
            MethodParameterOut p = (MethodParameterOut)storedNode;
            return Some$.MODULE$.apply((Object)Accessors.AccessPropertyName$.MODULE$.name$extension(package$.MODULE$.accessPropertyName((StoredNode)p)));
        }
        return None$.MODULE$;
    }
}

