/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.queryengine;

import flatgraph.GNode;
import io.joern.dataflowengineoss.queryengine.Engine$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.dataflowengineoss.queryengine.HeldTaskCompletion;
import io.joern.dataflowengineoss.queryengine.TaskSolver;
import io.joern.dataflowengineoss.queryengine.package;
import io.joern.dataflowengineoss.queryengine.package$ReachableByTask$;
import io.joern.dataflowengineoss.queryengine.package$TaskFingerprint$;
import io.joern.dataflowengineoss.semanticsloader.FlowSemantic;
import io.joern.dataflowengineoss.semanticsloader.Semantics;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import java.io.Serializable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Engine {
    private final EngineContext context;
    private final Logger logger;
    private final ExecutorService executorService;
    private final ExecutorCompletionService<package.TaskSummary> completionService;
    private final Map<package.TaskFingerprint, List<package.TableEntry>> mainResultTable;
    private int numberOfTasksRunning;
    private final HashSet<package.TaskFingerprint> started;
    private final Buffer<package.ReachableByTask> held;

    public static List<Method> argToMethods(Expression expression) {
        return Engine$.MODULE$.argToMethods(expression);
    }

    public static Iterator<MethodParameterOut> argToOutputParams(Expression expression) {
        return Engine$.MODULE$.argToOutputParams(expression);
    }

    public static Vector<package.PathElement> expandIn(CfgNode cfgNode, Vector<package.PathElement> vector, List<Call> list, Semantics semantics) {
        return Engine$.MODULE$.expandIn(cfgNode, vector, list, semantics);
    }

    public static boolean isCallToInternalMethod(Call call) {
        return Engine$.MODULE$.isCallToInternalMethod(call);
    }

    public static boolean isCallToInternalMethodWithoutSemantic(Call call, Semantics semantics) {
        return Engine$.MODULE$.isCallToInternalMethodWithoutSemantic(call, semantics);
    }

    public static boolean isOutputArgOfInternalMethod(Expression expression, Semantics semantics) {
        return Engine$.MODULE$.isOutputArgOfInternalMethod(expression, semantics);
    }

    public static List<Method> methodsForCall(Call call) {
        return Engine$.MODULE$.methodsForCall(call);
    }

    public static List<FlowSemantic> semanticsForCall(Call call, Semantics semantics) {
        return Engine$.MODULE$.semanticsForCall(call, semantics);
    }

    public static List<Call> expandIn$default$3() {
        return Engine$.MODULE$.expandIn$default$3();
    }

    public Engine(EngineContext context) {
        this.context = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.executorService = Executors.newWorkStealingPool();
        this.completionService = new ExecutorCompletionService(this.executorService);
        this.mainResultTable = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.numberOfTasksRunning = 0;
        this.started = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.TaskFingerprint[0]));
        this.held = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.ReachableByTask[0]));
    }

    public List<package.TableEntry> backwards(List<CfgNode> sinks, List<CfgNode> sources) {
        if (sources.isEmpty()) {
            this.logger.info("Attempting to determine flows from empty list of sources.");
        }
        if (sinks.isEmpty()) {
            this.logger.info("Attempting to determine flows to empty list of sinks.");
        }
        this.reset();
        Set sourcesSet = sources.toSet();
        List<package.ReachableByTask> tasks = this.createOneTaskPerSink(sinks);
        return this.solveTasks(tasks, (Set<CfgNode>)sourcesSet, sinks);
    }

    private void reset() {
        this.mainResultTable.clear();
        this.numberOfTasksRunning = 0;
        this.started.clear();
        this.held.clear();
    }

    private List<package.ReachableByTask> createOneTaskPerSink(List<CfgNode> sinks) {
        return sinks.map((Function1 & Serializable)sink -> package$ReachableByTask$.MODULE$.apply((List<package.TaskFingerprint>)((List)new .colon.colon((Object)package$TaskFingerprint$.MODULE$.apply((CfgNode)sink, (List<Call>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), 0), (List)Nil$.MODULE$)), (Vector<package.PathElement>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])))));
    }

    private List<package.TableEntry> solveTasks(List<package.ReachableByTask> tasks, Set<CfgNode> sources, List<CfgNode> sinks) {
        this.submitTasks((Vector<package.ReachableByTask>)tasks.toVector(), sources);
        long startTimeSec = System.currentTimeMillis() / 1000L;
        this.runUntilAllTasksAreSolved$1(sources);
        long taskFinishTimeSec = System.currentTimeMillis() / 1000L;
        this.logger.debug("Time measurement -----> Task processing done in " + (taskFinishTimeSec - startTimeSec) + " seconds");
        new HeldTaskCompletion((List<package.ReachableByTask>)this.held.toList(), this.mainResultTable).completeHeldTasks();
        List<package.TableEntry> dedupResult = this.deduplicateFinal(this.extractResultsFromTable(sinks));
        long allDoneTimeSec = System.currentTimeMillis() / 1000L;
        this.logger.debug("Time measurement -----> Task processing: " + (taskFinishTimeSec - startTimeSec) + " seconds, Deduplication: " + (allDoneTimeSec - taskFinishTimeSec) + ", Deduped results size: " + dedupResult.length());
        return dedupResult;
    }

    private void submitTasks(Vector<package.ReachableByTask> tasks, Set<CfgNode> sources) {
        tasks.foreach((Function1 & Serializable)task -> {
            if (this.started.contains((Object)task.fingerprint())) {
                return this.held.$plus$plus$eq((IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.ReachableByTask[]{task})));
            }
            this.started.add((Object)task.fingerprint());
            ++this.numberOfTasksRunning;
            return this.completionService.submit(new TaskSolver((package.ReachableByTask)task, this.context, sources));
        });
    }

    private List<package.TableEntry> extractResultsFromTable(List<CfgNode> sinks) {
        return sinks.flatMap((Function1 & Serializable)sink -> {
            List results;
            Option option = this.mainResultTable.get((Object)package$TaskFingerprint$.MODULE$.apply((CfgNode)sink, (List<Call>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), 0));
            return (IterableOnce)(option instanceof Some ? (results = (List)((Some)option).value()) : (DefaultSerializable)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        });
    }

    private List<package.TableEntry> deduplicateFinal(List<package.TableEntry> list) {
        return ((IterableOnceOps)list.groupBy((Function1 & Serializable)result -> {
            AstNode head = ((package.PathElement)result.path().head()).node();
            AstNode last = ((package.PathElement)result.path().last()).node();
            return Tuple2$.MODULE$.apply((Object)head, (Object)last);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Nil$ nil$;
                List list = (List)tuple2._2();
                List lenIdPathPairs = list.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x.path().length()), x));
                List list2 = ((List)lenIdPathPairs.sortBy((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3._1()), (Ordering)Ordering.Int$.MODULE$)).reverse();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list3 = list2;
                if (!(nil$2 != null ? !nil$2.equals(list3) : list3 != null)) {
                    nil$ = package$.MODULE$.Nil();
                } else if (list2 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    List list4 = colon2.next();
                    Tuple2 h = (Tuple2)colon2.head();
                    List t = list4;
                    nil$ = t.takeWhile((Function1 & Serializable)y -> BoxesRunTime.unboxToInt((Object)y._1()) == BoxesRunTime.unboxToInt((Object)h._1())).$colon$colon((Object)h);
                } else {
                    throw new MatchError((Object)list2);
                }
                List withMaxLength = nil$.map((Function1 & Serializable)_$4 -> (package.TableEntry)_$4._2());
                if (withMaxLength.length() == 1) {
                    return (package.TableEntry)withMaxLength.head();
                }
                return (package.TableEntry)withMaxLength.minBy((Function1 & Serializable)x2 -> ((IterableOnceOps)x2.path().map((Function1 & Serializable)x -> Tuple5$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((GNode)x.node()).id()), (Object)x.callSiteStack().map((Function1 & Serializable)_$5 -> _$5.id()), (Object)BoxesRunTime.boxToBoolean((boolean)x.visible()), (Object)BoxesRunTime.boxToBoolean((boolean)x.isOutputArg()), (Object)x.outEdgeLabel()).toString())).mkString("-"), (Ordering)Ordering.String$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private final void handleSummary$1(Set sources$1, package.TaskSummary taskSummary) {
        Vector<package.ReachableByTask> newTasks = taskSummary.followupTasks();
        this.submitTasks(newTasks, (Set<CfgNode>)sources$1);
        Vector<Tuple2<package.TaskFingerprint, package.TableEntry>> newResults = taskSummary.tableEntries();
        this.addEntriesToMainTable$1(newResults);
    }

    private final void addEntriesToMainTable$1(Vector entries) {
        entries.groupBy((Function1 & Serializable)_$1 -> (package.TaskFingerprint)_$1._1()).foreach((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                package.TaskFingerprint fingerprint = (package.TaskFingerprint)tuple2._1();
                Vector entryList = (Vector)tuple2._2();
                List entries = ((IterableOnceOps)entryList.map((Function1 & Serializable)_$2 -> (package.TableEntry)_$2._2())).toList();
                return this.mainResultTable.updateWith((Object)fingerprint, (Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        List list = (List)((Some)option).value();
                        return Some$.MODULE$.apply(list.$plus$plus((IterableOnce)entries));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Some$.MODULE$.apply((Object)entries);
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final package.TaskSummary runUntilAllTasksAreSolved$1$$anonfun$1() {
        return this.completionService.take().get();
    }

    private final void runUntilAllTasksAreSolved$1(Set sources$3) {
        while (this.numberOfTasksRunning > 0) {
            Try try_ = Try$.MODULE$.apply(this::runUntilAllTasksAreSolved$1$$anonfun$1);
            if (try_ instanceof Success) {
                package.TaskSummary resultsOfTask = (package.TaskSummary)((Success)try_).value();
                --this.numberOfTasksRunning;
                this.handleSummary$1(sources$3, resultsOfTask);
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                --this.numberOfTasksRunning;
                this.logger.warn("SolveTask failed with exception:", exception);
                exception.printStackTrace();
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }
}

